#ifndef __PARSE_MP3_H
#define __PARSE_MP3_H

/* NOTE: this is the reverse order that it appears in the file */
typedef struct {
   unsigned char emphasis : 2;
   unsigned char original : 1;
   unsigned char copyright : 1;
   unsigned char mode_ext : 2;
   unsigned char mode : 2;
   unsigned char private_bit : 1;
   unsigned char padding_bit : 1;
   unsigned char frequency : 2;
   unsigned char bitrate_index : 4;
   unsigned char protection_bit : 1;
   unsigned char layer : 2;
   unsigned char id : 1;
   unsigned char index : 1;
   unsigned short frame_sync : 11; /* all bits set */
} MP3Header;

/* prototypes */
void mp3_register();
int mp3_ext(char *ext);
int read_byte(int fd, guint32 *hdr);
int vbr_frame_count(unsigned char *hdr);
int find_mp3_header(int fd, guint32 *hdr);
void get_mp3_header(guint32 hdr, MP3Header *h);
ShareData *process_mp3_header(int fd, guint32 hdr);
char *get_checksum(int fd, unsigned long mapsize);
ShareData *parse_mp3(char *file, int fd);
/* !prototypes */

#endif /* __PARSE_MP3_H */
