/* parse_avi.c - Being able to share .avi's */

#include "gnapster.h"

#include "parse_avi.h"
#include "parse_ext.h"

void avi_register() {
   REGISTER_EXT("avi", "video", parse_avi, avi_ext);
}

int avi_ext(char *ext) {
   return (strcasecmp(ext, "avi") == 0);
}

ShareData *parse_avi(char *file, int fd) {
   ShareData *shr;
   struct stat st;
   
   shr = d_new(SHARE);
   
   fstat(fd, &st);
   
   shr->filename = d_strdup(file);
   shr->checksum = d_strdup("00000000000000000000000000000000");
   
   shr->mtime = st.st_mtime;
   shr->filesize = st.st_size;
 
   /* fix me: this should be real data ;) */
   shr->bitrate = 0;
   shr->frequency = 0;
   shr->time = 0.0;
   
   return shr;
}
