#ifndef __MENUS_H
#define __MENUS_H

#include "callbacks.h"
#include "download.h"
#include "queue.h"
#include "resume.h"
#include "servers.h"
#include "chan.h"

/*static JMenuInterface[] = {
   MENU_BRANCH("/_File/"),
   MENU_ITEM("/File/_Connect to last server", 'C', connect_last_cb),
   MENU_ITEM("/File/Connect to _official server", 'O', connect_official_cb),
   MENU_ITEM("/File/_Disconnect", 'D', disconnect_cb),
   MENU_SEPARATOR(),
   MENU_ITEM("/File/_Safe exit", 'S', safe_exit_cb),
   MENU_ITEM("/File/_Exit", 'Q', gnapster_exit_cb),

   MENU_BRANCH("/_Servers"),
   MENU_ITEM("/Servers/New Server _Tab", 'T', create_stab),
   MENU_ITEM("/Servers/_Remove Server Tab", 'R', remove_stab),
   MENU_SEPARATOR(),
   MENU_ITEM("/Servers/Save Server Setup", 'P', stab_snapshot),
   MENU_SEPARATOR(),
   MENU_ITEM("/Servers/_Browse OpenNAP Servers...", 'B', browse_opennap_cb),
   
   MENU_BRANCH("/_Napster/"),

        {N_("/_Servers"), NULL, NULL, 0, "<Branch>"},
        {N_("/Servers/New Server _Tab"), "<control>T", create_stab, 0, NULL},
        {N_("/Servers/_Remove Server Tab"), "<control>R", remove_stab, 0, NULL},
	{N_("/Servers/_sep1"), NULL, NULL, 0, "<Separator>"},
        {N_("/Servers/Save Server Setup"), "<control>P", stab_snapshot, 0, NULL},
        {N_("/Servers/_sep2"), NULL, NULL, 0, "<Separator>"},
	{N_("/Servers/_Browse OpenNAP servers..."), "<control>B", browse_opennap_cb, 0, NULL},

        {N_("/_Napster"), NULL, NULL, 0, "<Branch>"},
	{N_("/Napster/Resume download..."), NULL, resume_download_cb, 0, NULL},
	{N_("/Napster/sep1"), NULL, NULL, 0, "<Separator>"},
	{N_("/Napster/List channels..."), NULL, list_chan_cb, 0, NULL},
	{N_("/Napster/Join Channel..."), NULL, join_chan_cb, 0, NULL},
	{N_("/Napster/Part Channel"), NULL, part_chan_cb, 0},
	{N_("/Napster/sep2"), NULL, NULL, 0, "<Separator>"},
	{N_("/Napster/Query user..."), NULL, query_user_cb, 0, NULL},
	{N_("/Napster/Unquery user..."), NULL, unquery_user_cb, 0, NULL},
	{N_("/Napster/sep3"), NULL, NULL, 0, "<Separator>"},
	{N_("/Napster/Update shared file"), "<control>U", update_shares_cb, 0, NULL},

	{N_("/_Settings"), NULL, NULL, 0, "<Branch>"},
        {N_("/Settings/Accounts..."), NULL, create_accounts_cb, 0, NULL},
	{N_("/Settings/Preferences"), NULL, preferences_cb, 0, NULL},

	{N_("/_Help"), NULL, NULL, 0, "<LastBranch>"},
	{N_("/Help/About..."), NULL, about_cb, 0, NULL}
};

};

#if 0*/

#ifdef HAVE_GNOME

#define MY_STOCK(label, callback, stock_id, key) \
{ GNOME_APP_UI_ITEM, label, NULL, (gpointer)callback, NULL, NULL, \
  GNOME_APP_PIXMAP_STOCK, stock_id, key, GDK_CONTROL_MASK, NULL }

#define MY_STOCK_CB(label, callback, user_data, stock_id) \
{ GNOME_APP_UI_ITEM, label, NULL, (gpointer)callback, user_data, NULL, \
  GNOME_APP_PIXMAP_STOCK, stock_id, 0, (GdkModifierType) 0, NULL }

#define MY_ITEM(label, callback, key) \
{ GNOME_APP_UI_ITEM, label, NULL, (gpointer)callback, NULL, NULL, \
  GNOME_APP_PIXMAP_NONE, NULL, key, GDK_CONTROL_MASK, NULL }



static GnomeUIInfo gnapster_file_menu[] = {
   MY_STOCK("_Connect to last server", connect_last_cb, GNOME_STOCK_MENU_EXEC, 'C'),
   MY_STOCK("Connect to _official server", connect_official_cb,
	    GNOME_STOCK_MENU_EXEC, 'O'),
   MY_STOCK("_Disconnect", disconnect_cb, GNOME_STOCK_MENU_TRASH, 'D'),
   MY_ITEM("Disconnect All", disconnect_all_cb, 0),
   MY_ITEM("Reconnect All", reconnect_all_cb, 0),
   GNOMEUIINFO_SEPARATOR,
   MY_ITEM("_Safe exit", safe_exit_cb, 'S'),
   GNOMEUIINFO_MENU_EXIT_ITEM(gnapster_exit_cb, NULL),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_stab_menu[] = {
   MY_ITEM("New Server _Tab", create_stab, 'T'),
   MY_ITEM("_Remove Server Tab", remove_stab, 'R'),
   GNOMEUIINFO_TOGGLEITEM("Show Server Tabs", NULL, show_stabs_gnome, NULL),
   GNOMEUIINFO_SEPARATOR,
   MY_STOCK("Save Server Setup", stab_snapshot, GNOME_STOCK_MENU_SAVE, 'P'),
   GNOMEUIINFO_SEPARATOR,
   MY_ITEM("Server Links", server_links_cb, 0),
   MY_STOCK("_Browse OpenNAP servers...", browse_opennap_cb,
	    GNOME_STOCK_MENU_INDEX, 'B'),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_transfers_menu[] = {
   MY_ITEM("Total Statistics", total_xfer_stats, 0),
   MY_ITEM("Current Server Statistics", xfer_stats, 0),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_napster_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Resume download..."), NULL, resume_download_cb,
			  GNOME_STOCK_MENU_SEARCH),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("List channels..."), NULL, list_chan_cb,
			  GNOME_STOCK_MENU_SEARCH),
   GNOMEUIINFO_ITEM_STOCK(N_("Join Channel..."), NULL, join_chan_cb,
			  GNOME_STOCK_MENU_MIC),
   GNOMEUIINFO_ITEM_STOCK(N_("Part Channel"), NULL, part_chan_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Query user..."), NULL, query_user_cb,
			  GNOME_STOCK_MENU_MIC),
   GNOMEUIINFO_ITEM_STOCK(N_("Unquery user"), NULL, unquery_user_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_SEPARATOR,
   MY_STOCK(N_("Update shared file"), update_shares_cb,
	    GNOME_STOCK_MENU_SAVE_AS, 'U'),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_settings_menu[] = {
   MY_ITEM(N_("Accounts..."), create_accounts_cb, 0),
   GNOMEUIINFO_MENU_PREFERENCES_ITEM(preferences_cb, NULL),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_help_menu[] = {
   GNOMEUIINFO_MENU_ABOUT_ITEM(about_cb, NULL),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_menu[] = {
   GNOMEUIINFO_MENU_FILE_TREE(gnapster_file_menu),
   GNOMEUIINFO_SUBTREE(N_("_Servers"), gnapster_stab_menu),
   GNOMEUIINFO_SUBTREE(N_("_Transfers"), gnapster_transfers_menu),
   GNOMEUIINFO_SUBTREE(N_("_Napster"), gnapster_napster_menu),
   GNOMEUIINFO_MENU_SETTINGS_TREE(gnapster_settings_menu),
   GNOMEUIINFO_MENU_HELP_TREE(gnapster_help_menu),
   GNOMEUIINFO_END,
};

#else

static GtkItemFactoryEntry search_popup_menu_data[] = {
	{N_("/Download"), 0, thunk, SEARCH_DOWNLOAD_CB, NULL},
	{"/sep1", 0, 0, 0, "<Separator>"},
	{N_("/Browse user's mp3s"), 0, thunk, BROWSE_USER_MENU_CB, NULL},
	{N_("/Whois user"), 0, thunk, WHOIS_USER_MENU_CB, NULL}
};

static GtkItemFactoryEntry browse_popup_menu_data[] = {
	{N_("/Download"), 0, thunk, BROWSE_DOWNLOAD_CB, NULL}
};

static GtkItemFactoryEntry download_popup_menu_data[] = { 
	{N_("/Browse user's mp3s"), 0, thunk, BROWSE_USER_MENU_CB, NULL},	
	{N_("/Whois user"), 0, thunk, WHOIS_USER_MENU_CB, NULL},
	{"/sep1", 0, 0, 0, "<Separator>"},
	{N_("/Retry download"), 0, thunk, RETRY_DOWNLOAD_CB, NULL},
	{"/sep2", 0, 0, 0, "<Separator>"},
        {N_("/Move to queue"), 0, thunk, MOVEQUEUE_CB, NULL},
	{"/sep3", 0, 0, 0, "<Separator>"},
	{N_("/Cancel download"), 0, thunk, CANCEL_DOWNLOAD_CB, NULL},
	{N_("/Cancel and remove file"), 0, thunk, CANCEL_REMOVE_CB, NULL}
};

static GtkItemFactoryEntry upload_popup_menu_data[] = {
	{N_("/Browse user's mp3s"), 0, thunk, BROWSE_USER_MENU_CB, NULL},
	{N_("/Whois user"), 0, thunk, WHOIS_USER_MENU_CB, NULL},
	{"/sep1", 0, 0, 0, "<Separator>"},
	{N_("/Cancel upload"), 0, thunk, CANCEL_UPLOAD_CB, NULL}
};

static GtkItemFactoryEntry queue_popup_menu_data[] = {
	{N_("/Browse user's mp3s"), 0, thunk, BROWSE_USER_MENU_CB, NULL},
	{N_("/Whois user"), 0, thunk, WHOIS_USER_MENU_CB, NULL},
	{"/sep1", 0, 0, 0,  "<Separator>"},
	{N_("/Force download"), 0, thunk, FORCE_QUEUE_CB, NULL},
	{N_("/Cancel queue"), 0, thunk, CANCEL_QUEUE_CB, NULL}
};

static GtkItemFactoryEntry chat_popup_menu_data[] = {
	{N_("/Browse user's mp3s"), 0, thunk, BROWSE_USER_MENU_CB, NULL},
	{N_("/Whois user"), 0, thunk, WHOIS_USER_MENU_CB, NULL}
};

static GtkItemFactoryEntry gnapster_menu[] = {
	{N_("/_File"), NULL, NULL, 0, "<Branch>"},
	{N_("/File/_Connect to last server"), "<control>C", connect_last_cb, 0, NULL},
	{N_("/File/Connect to _official server"), "<control>O", connect_official_cb, 0, NULL},
	{N_("/File/_Disconnect"), "<control>D", disconnect_cb, 0, NULL},
        {N_("/File/Disconnect All"), NULL, disconnect_all_cb, 0, NULL},
        {N_("/File/Reconnect All"), NULL, reconnect_all_cb, 0, NULL},
	{N_("/File/_sep1"), NULL, NULL, 0, "<Separator>"},
	{N_("/File/_Safe exit"), "<control>S", safe_exit_cb, 0, NULL},
	{N_("/File/_Exit"), "<control>Q", gnapster_exit_cb, 0, NULL},

        {N_("/_Servers"), NULL, NULL, 0, "<Branch>"},
        {N_("/Servers/New Server _Tab"), "<control>T", create_stab, 0, NULL},
        {N_("/Servers/_Remove Server Tab"), "<control>R", remove_stab, 0, NULL},
        {N_("/Servers/Show Server Tabs"), NULL, show_stabs_gtk, 0, "<CheckItem>"},
	{N_("/Servers/_sep1"), NULL, NULL, 0, "<Separator>"},
        {N_("/Servers/Save Server Setup"), "<control>P", stab_snapshot, 0, NULL},
        {N_("/Servers/_sep2"), NULL, NULL, 0, "<Separator>"},
        {N_("/Servers/Server Links..."), NULL, server_links_cb, 0, NULL},
	{N_("/Servers/_Browse OpenNAP servers..."), "<control>B", browse_opennap_cb, 0, NULL},
        {N_("/Servers/_sep3"), NULL, NULL, 0, "<Separator>"},
   
        {N_("/_Transfers"), NULL, NULL, 0, "<Branch>"},
        {N_("/Transfers/Total Statistics"), NULL, total_xfer_stats, 0, NULL},
	{N_("/Transfers/Current Server Statistics"), NULL, xfer_stats, 0, NULL},

        {N_("/_Napster"), NULL, NULL, 0, "<Branch>"},
	{N_("/Napster/Resume download..."), NULL, resume_download_cb, 0, NULL},
	{N_("/Napster/sep1"), NULL, NULL, 0, "<Separator>"},
	{N_("/Napster/List channels..."), NULL, list_chan_cb, 0, NULL},
	{N_("/Napster/Join Channel..."), NULL, join_chan_cb, 0, NULL},
	{N_("/Napster/Part Channel"), NULL, part_chan_cb, 0},
	{N_("/Napster/sep2"), NULL, NULL, 0, "<Separator>"},
	{N_("/Napster/Query user..."), NULL, query_user_cb, 0, NULL},
	{N_("/Napster/Unquery user..."), NULL, unquery_user_cb, 0, NULL},
	{N_("/Napster/sep3"), NULL, NULL, 0, "<Separator>"},
	{N_("/Napster/Update shared file"), "<control>U", update_shares_cb, 0, NULL},

	{N_("/_Settings"), NULL, NULL, 0, "<Branch>"},
        {N_("/Settings/Accounts..."), NULL, create_accounts_cb, 0, NULL},
	{N_("/Settings/Preferences"), NULL, preferences_cb, 0, NULL},

	{N_("/_Help"), NULL, NULL, 0, "<LastBranch>"},
	{N_("/Help/About..."), NULL, about_cb, 0, NULL}
};

#endif /* HAVE_GNOME */

/*#endif *//* 0 */
#endif /* __MENUS_H */
