#include "gnapster.h"

#include "menu.h"

extern GnapsterMain *gmain;

#ifdef HAVE_GNOME

int offs_pos = 0;

void append_menu(char *path, char a, void *cb, void *data, void *holder) {
   GtkWidget *shell;
   char *tpath;
   int pos;
   GnomeUIInfo ent[] = {
      { GNOME_APP_UI_ITEM, NULL, NULL, NULL, NULL, NULL, 0, 0, GDK_VoidSymbol, 0 },
      GNOMEUIINFO_END
   };
   
   pos = 0;
   
   /* set the first entry */
   ent->type = GNOME_APP_UI_ITEM;
   
   if ((tpath = strrchr(path, '/')))
     tpath++;
   else
     return;
   
   str_trans(tpath, '.', ' ');
   
   ent->label = tpath;
   ent->hint = NULL;
   
   ent->moreinfo = cb;
   ent->user_data = data;
   
   ent->unused_data = NULL;
   
   ent->pixmap_type = GNOME_APP_PIXMAP_NONE;
   ent->pixmap_info = NULL;
   
   ent->accelerator_key = a;
   ent->ac_mods = GDK_CONTROL_MASK;
   
   ent->widget = NULL;
   
   shell = gnome_app_find_menu_pos(GNOME_APP(gmain->window)->menubar, 
				   "Servers/_Browse OpenNAP servers...",
				   &pos);
   if (!shell || !pos)
     return;
   
   gnome_app_fill_menu(GTK_MENU_SHELL(shell), ent,
		       GNOME_APP(gmain->window)->accel_group, TRUE, 
		       ++offs_pos + pos);
   gnome_app_install_menu_hints(GNOME_APP(gmain->window), ent);
}

void remove_menu(char *path) {
   GtkWidget *shell, *child;
   GtkMenuShell *mshell;
   int pos = 0;
   
   offs_pos = 0;
   
   shell = gnome_app_find_menu_pos(GNOME_APP(gmain->window)->menubar, 
				   "Servers/_Browse OpenNAP servers...",
				   &pos);
   
   if (!shell || !pos)
     return;
   
   mshell = GTK_MENU_SHELL(shell);
   
   child = g_list_nth_data(mshell->children, pos + 1);
   if (!child)
     return;
   
   child = GTK_WIDGET(child);
   
   if (GTK_IS_ACCEL_LABEL(GTK_BIN(child)->child)) {
      gtk_accel_label_set_accel_widget(GTK_ACCEL_LABEL(GTK_BIN(child)->child),
				       NULL);
      gtk_widget_destroy(GTK_WIDGET(GTK_BIN(child)->child));
   }
   
   mshell->children = g_list_remove(mshell->children, child);
   
   gtk_widget_unparent(child);

   gtk_widget_queue_resize(shell);
}

#else

extern GtkItemFactory *ifactory;
  
void append_menu(char *path, char a, GtkItemFactoryCallback cb, void *data, char *type) {
   GtkItemFactoryEntry *ent;
   
   ent = d_malloc(sizeof(GtkItemFactoryEntry));
   
   ent->path = path;
   d_msprintf(&(ent->accelerator), "<control>%c", a);
   ent->callback = cb;
   ent->callback_action = 0;
   ent->item_type = type;

   gtk_item_factory_create_item(ifactory, ent, data, 1);

   d_free(ent->accelerator);
   d_free(ent);
}

void remove_menu(char *path) {
   gtk_item_factory_delete_item(ifactory, path);
}

#endif /* HAVE_GNOME */

void remove_server_menu() {
   char *path;
   
   FORSTABS(if (!stab->ci->server) continue;
	    d_msprintf(&path, "/Servers/%s", stab->ci->server);
	    remove_bt_servers(stab);
	    remove_menu(path);
	    d_free(path));
}

void append_server_menu() {
   char *path;
   void *cbfunc;
   int a = '1';
   
#ifdef HAVE_GNOME
   cbfunc = switch_stab_gnome;
#else
   cbfunc = switch_stab_gtk;
#endif /* HAVE_GNOME */
   
   FORSTABS(if (!stab->ci->server) continue;
	    d_msprintf(&path, "/Servers/%s", stab->ci->server);
	    append_bt_server(stab);
	    append_menu(path, a++, cbfunc, stab, NULL);
	    d_free(path));
}

