#!/usr/bin/perl

die "usage: ./leak.pl <debug.out>" unless ($#ARGV >= 0);

while (<>) {
   next unless (/^0x/); # require an address to start with
   
   ($addy, $file, $line, $rpt, $avg, $size) = 
      split /[\s\t]+/;

   my (%ent) = ( file => $file, 
                 line => $line, 
		 size => $size, 
		 data => undef );

   # Get data at file:line
   open FH, "$file";
   while(<FH>) { if ($. == $line) { s/^[\s\t]*//; $ent{'data'} = $_; last; } }
   close FH;
   
   push @list, \%ent;
}

# sort by size (descending)
foreach $ent (sort { $$b{'size'} <=> $$a{'size'} } @list) {
   printf "%-15s:%-5i (%-5i): %s", 
      $$ent{'file'}, $$ent{'line'}, $$ent{'size'}, $$ent{'data'};
}
