/* fuckgnome.c - Tentatively named, don't you think? */

#include "xtext.h"

#include "gnapster.h"
#include "servers.h"
#include "resume.h"
#include "chan.h"
#include "themes.h"

extern PropDlg prop_dlg;

GList *dialogs = NULL;
GList *key_table = NULL;

#ifndef HAVE_GNOME
GList *jdialog_widgets = NULL;
#endif /* !HAVE_GNOME */

void j_dialog_close(GtkWidget *dialog) {
#ifdef HAVE_GNOME
   gnome_dialog_close(GNOME_DIALOG(dialog));
#else
   gtk_widget_destroy(dialog);
#endif /* HAVE_GNOME */
}

void j_dialog_run_close(GtkWidget *widget, DialogRunInfo *ri) {
#ifdef HAVE_GNOME
   j_dialog_close(widget);
#else
   if (!ri->destroyed) {
      gtk_signal_disconnect(GTK_OBJECT(widget),
			    ri->close_id);
      
      ri->close_id = -1;
   }

   gtk_main_quit();
#endif /* HAVE_GNOME */
}

void j_dialog_run_destroy(GtkWidget *widget, DialogRunInfo *ri) {
#ifndef HAVE_GNOME
   ri->destroyed = 1;
   
   j_dialog_run_close(widget, ri);
#endif /* !HAVE_GNOME */
}

void j_dialog_run(GtkWidget *widget, int close_after) {
#ifdef HAVE_GNOME
   if (!close_after)
     gnome_dialog_run(GNOME_DIALOG(widget));
   else
     gnome_dialog_run_and_close(GNOME_DIALOG(widget));
#else
   int was_modal;
   DialogRunInfo ri = {
      -1, -1, -1, -1, 0
   };
   
   if (!widget)
     return;
   
   was_modal = GTK_WINDOW(widget)->modal;
   if (!was_modal) 
     gtk_window_set_modal(GTK_WINDOW(widget), 1);
   
   ri.close_id = gtk_signal_connect(GTK_OBJECT(widget), "delete_event",
				    GTK_SIGNAL_FUNC(j_dialog_run_close), &ri);
   
   ri.destroy_id = gtk_signal_connect(GTK_OBJECT(widget), "destroy",
				      GTK_SIGNAL_FUNC(j_dialog_run_destroy), &ri);
   
   if (!GTK_WIDGET_VISIBLE(GTK_WIDGET(widget)))
     gtk_widget_show(GTK_WIDGET(widget));
   
   gtk_main();
   
   if (ri.destroyed)
     return;
   
   if (!was_modal)
     gtk_window_set_modal(GTK_WINDOW(widget), 0);
   
   if (close_after)
     j_dialog_close(widget);
#endif /* HAVE_GNOME */
}

/* this will cleanup jdialog_widgets too, so use it! */
void j_dialog_show(GtkWidget *dialog, GtkWidget *vbox) {
#ifdef HAVE_GNOME
   gtk_container_add(GTK_CONTAINER(GNOME_DIALOG(dialog)->vbox),
		     vbox);
#else
   g_list_free(jdialog_widgets);
   jdialog_widgets = NULL;
#endif /* HAVE_GNOME */

   gtk_widget_show_all(dialog);
}

GtkWidget *j_dialog_vbox(GtkWidget *dialog) {
   GtkWidget *vbox;
   
#ifdef HAVE_GNOME
   vbox = gtk_vbox_new(FALSE, 5);
#else
   vbox = GTK_DIALOG(dialog)->vbox;
   
   gtk_box_set_spacing(GTK_BOX(vbox), 5);
   gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
#endif /* HAVE_GNOME */
   
   return vbox;
}

void j_dialog_button_connect(GtkWidget *dialog, int button, void *func, void *data) {
   GtkWidget *jdialog_widget;
   
   UNUSED(jdialog_widget);

#ifdef HAVE_GNOME
   gnome_dialog_button_connect(GNOME_DIALOG(dialog), button,
			       GTK_SIGNAL_FUNC(func), data);
#else
   jdialog_widget = g_list_nth_data(jdialog_widgets, button);
   
   gtk_signal_connect(GTK_OBJECT(jdialog_widget), "clicked",
		      GTK_SIGNAL_FUNC(func), data);
#endif /* HAVE_GNOME */
}

void j_dialog_button_connect_close(GtkWidget *dialog, int button,
				   void *func, void *data) {
   GtkWidget *jdialog_widget;
   
   UNUSED(jdialog_widget);

#ifdef HAVE_GNOME
   gnome_dialog_button_connect(GNOME_DIALOG(dialog), button,
			       GTK_SIGNAL_FUNC(func), data);
#else
   jdialog_widget = g_list_nth_data(jdialog_widgets, button);
   
   gtk_signal_connect_object(GTK_OBJECT(jdialog_widget), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
#endif /* HAVE_GNOME */
}

void j_dialog_destroy(GtkWidget *widget, GdkEvent *event, void *data) {
   dialogs = g_list_remove(dialogs, widget);
}

GtkWidget *j_dialog_new(char *title, ...) {
#ifdef HAVE_GNOME
   GnomeDialog *dialog;
#else
   GtkWidget *dialog, *button_widget;
   char *button;
#endif /* HAVE_GNOME */
   va_list args;
   
#ifdef HAVE_GNOME
   dialog = gtk_type_new(gnome_dialog_get_type());
#else
   dialog = gtk_dialog_new();
   gtk_window_set_title(GTK_WINDOW(dialog), title);
  
/*   gtk_widget_set_usize(GTK_WIDGET(GTK_DIALOG(dialog)->action_area), -1, 50);
   gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area),
				  12);*/
#endif /* HAVE_GNOME */
   
   va_start(args, title);
#ifdef HAVE_GNOME
   gnome_dialog_construct(dialog, title, args);
   gtk_window_set_policy(GTK_WINDOW(dialog), 1, 1, 0);
#else   
   for(;;) {
      button = va_arg(args, char *);
      if (!button)
	break;
      
      if (strstr(button, "Button_"))
	button += strlen("Button_");
      
      button_widget = gtk_button_new_with_label(button);
      gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button_widget,
			 0, 1, 0);

      jdialog_widgets = g_list_append(jdialog_widgets, button_widget);
   }
#endif /* HAVE_GNOME */
   va_end(args);

   dialogs = g_list_prepend(dialogs, GTK_WIDGET(dialog));
   
   gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
		      GTK_SIGNAL_FUNC(j_dialog_destroy), NULL);
   
   return GTK_WIDGET(dialog);
}

GtkWidget *j_about_new(const char *package, const char *version, const char *copyright, const char **authors, const char *desc, const char *logo) {
   GtkWidget *widget;
   
#ifdef HAVE_GNOME
   widget = gnome_about_new(package, version, copyright, authors, desc,
			    logo);
#else
   GtkWidget *hbox, *vbox, *avbox, *albl, *lbl;
   char *label;
   int i;
   
   widget = j_dialog_new(_("About Gnapster"), "OK", NULL);
   
   vbox = j_dialog_vbox(widget);
   
   hbox = j_line_new(vbox, 0, 0);
   
   d_msprintf(&label, "%s %s", package, version);

   lbl = gtk_label_new(label);
   j_box_pack(hbox, lbl, 1, 1, 0);
   
   d_free(label);
   
   hbox = j_line_new(vbox, 0, 0);
   
   lbl = gtk_label_new(copyright);
   j_box_pack(hbox, lbl, 0, 0, 0);
   
   hbox = j_line_new(vbox, 0, 0);
   
   avbox = gtk_vbox_new(FALSE, 5);
   j_box_pack(hbox, avbox, 1, 1, 0);
   
   hbox = j_line_new(avbox, 0, 0);
   
   albl = gtk_label_new("Author: ");
   j_box_pack(hbox, albl, 0, 0, 0);
   
   for(i=0; authors[i]; i++) {
      lbl = gtk_label_new(authors[i]);
      j_box_pack(hbox, lbl, 1, 1, 0);
      
      hbox = j_line_new(avbox, 0, 0);
   }
   
   if (i > 1)
     gtk_label_set_text(GTK_LABEL(albl), "Authors: ");
   
   hbox = j_line_new(vbox, 0, 0);
   
   lbl = gtk_label_new(desc);
   j_box_pack(hbox, lbl, 0, 0, 0);
   
   j_dialog_button_connect_close(widget, 0,
				 widget, NULL);
   
   j_dialog_show(widget, vbox);
#endif /* HAVE_GNOME */
   
   return widget;
}

GtkWidget *j_error_dialog(char *text) {
   GtkWidget *dialog;
   
#ifdef HAVE_GNOME
   dialog = gnome_error_dialog(text);
#else
   GtkWidget *vbox, *label;
   
   dialog = j_dialog_new(_("Error"), "OK", NULL);
   
   vbox = j_dialog_vbox(dialog);
   
   label = gtk_label_new(text);
   j_box_pack(vbox, label, 0, 0, 0);
   
   j_dialog_button_connect_close(dialog, 0,
				 dialog, NULL);
   
   j_dialog_show(dialog, vbox);
#endif /* HAVE_GNOME */
   
   return dialog;
}

void j_warning_dialog(char *text) {
#ifdef HAVE_GNOME
   gnome_warning_dialog(text);
#else
   GtkWidget *dlg;
   
   dlg = j_error_dialog(text);
   
   gtk_window_set_title(GTK_WINDOW(dlg), _("Warning"));
#endif /* HAVE_GNOME */
}

GtkWidget *j_question_dialog(const char *text, GnomeReplyCallback callback, void *data, GtkWindow *parent) {
   GtkWidget *dialog;
   
#ifdef HAVE_GNOME
   dialog = gnome_question_dialog_parented(text, callback, data, parent);
   
   gtk_widget_show(dialog);
#else
   GtkWidget *vbox, *lbl;
   int w, h, x, y;
   
   dialog = j_dialog_new(_("Question"), "Yes", "No", NULL);
   
   vbox = j_dialog_vbox(dialog);
   
   lbl = gtk_label_new(text);
   j_box_pack(vbox, lbl, 1, 1, 0);
   
   gdk_window_get_size(GTK_WIDGET(parent)->window, &w, &h);
   gdk_window_get_position(GTK_WIDGET(parent)->window, &x, &y);
   x += w/2;
   y += h/2;
   
   gtk_widget_set_uposition(dialog, x, y);
   gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));
   gtk_window_set_modal(GTK_WINDOW(dialog), 1);
   
   j_dialog_button_connect(dialog, 0,
			   callback, data);
   j_dialog_button_connect(dialog, 1,
			   callback, NULL);
   
   j_dialog_button_connect_close(dialog, 0,
				 dialog, NULL);
   j_dialog_button_connect_close(dialog, 1, 
				 dialog, NULL);
   
   j_dialog_show(dialog, vbox);
#endif /* HAVE_GNOME */
   
   return dialog;
}

void j_property_box_changed(GtkWidget *widget) {
#ifdef HAVE_GNOME
   if (!dialog_open(prop_dlg.window))
     return;
   
   gnome_property_box_changed(GNOME_PROPERTY_BOX(prop_dlg.window));
#endif /* HAVE_GNOME */
}

void j_property_box_append_page(GtkWidget *vbox, GtkWidget *label) {
#ifdef HAVE_GNOME
   gnome_property_box_append_page(GNOME_PROPERTY_BOX(prop_dlg.window), vbox, label);
#else
   gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
   gtk_notebook_append_page(GTK_NOTEBOOK(prop_dlg.notebook), vbox, label);
#endif /* HAVE_GNOME */
}

GtkWidget *j_property_box_new() {
   GtkWidget *dialog;
   
#ifdef HAVE_GNOME
   dialog = gnome_property_box_new();
   
   gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
		      GTK_SIGNAL_FUNC(j_dialog_destroy), NULL);   
#else
   GtkWidget *vbox, *notebook;
   
   dialog = j_dialog_new(_("Gnapster Properties"), "OK", "Apply", "Cancel", NULL);
   
   vbox = j_dialog_vbox(dialog);
   
   notebook = gtk_notebook_new();
   j_box_pack(vbox, notebook, 1, 1, 0);
   
   j_dialog_button_connect(dialog, 0, 
			   preferences_button_cb, "ok");
   j_dialog_button_connect(dialog, 1,
			   preferences_button_cb, "apply");
   j_dialog_button_connect(dialog, 2,
			   preferences_destroy_cb, "destroy");
   
   prop_dlg.notebook = notebook;
#endif /* HAVE_GNOME */
   
   return dialog;
}

GtkWidget *j_entry_gtk_entry(GtkWidget *widget) {
   GtkWidget *gtk_entry;

#if 0
   gtk_entry = gnome_entry_gtk_entry(GNOME_ENTRY(widget));
#else
   gtk_entry = GTK_COMBO(widget)->entry;
#endif /* 0 */
   
   return gtk_entry;
}

void add_entry(GtkWidget *w, GtkWidget *data) {
   GtkWidget *li, *child, *lbl;
   GList *ptr;
   char *s, *str;
   
   s = gtk_entry_get_text(GTK_ENTRY(w));
   if (!s || !(*s))
     return;
   
   for(ptr=GTK_LIST(GTK_COMBO(data)->list)->children; ptr; ptr=ptr->next) {
      child = ptr->data;
      if (!child)
        continue;
      
      lbl = GTK_BIN(child)->child;
      
      str = GTK_LABEL(lbl)->label;
      
      if (!strcmp(str, s))
	return;
   }
   
   s = d_strdup(s);

   li = gtk_list_item_new_with_label(s);
   gtk_widget_show(li);
   
   gtk_container_add(GTK_CONTAINER(GTK_COMBO(data)->list), li);

   gtk_entry_set_text(GTK_ENTRY(w), s);
   
   d_free(s);
}

/* gnome_entry's actually quite suck.  so we're gonna use gtk_combo's for
 * both now */
GtkWidget *j_entry_new(char *history) {
   GtkWidget *widget;
   
#if 0
   widget = gnome_entry_new(history);
#else
   widget = gtk_combo_new();
   gtk_combo_disable_activate(GTK_COMBO(widget));
   gtk_signal_connect(GTK_OBJECT(GTK_COMBO(widget)->entry), "activate",
		      GTK_SIGNAL_FUNC(add_entry), widget);
#endif /* 0 */
   
   return widget;
}

GtkWidget *j_file_entry_gtk_entry(GtkWidget *widget) {
   GtkWidget *gtk_entry;
   
#ifdef HAVE_GNOME
   gtk_entry = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(widget));
#else
   gtk_entry = widget;
#endif /* HAVE_GNOME */
   
   return gtk_entry;
}

GtkWidget *j_file_entry_new(char *h, char *title) {
   GtkWidget *widget;
   
#ifdef HAVE_GNOME
   widget = gnome_file_entry_new(h, title);
#else
   widget = gtk_entry_new();
#endif /* HAVE_GNOME */
   
   return widget;
}

/* config shit */

FILE *open_config(char *flags) {
   FILE *f;
   char *conf;

#ifdef HAVE_GNOME
   d_msprintf(&conf, "%s/.gnome/gnapster", getenv("HOME"));
#else
   conf = local_path("gnapster.conf", NULL);
#endif /* HAVE_GNOME */
   
   f = fopen(conf, flags);

   d_free(conf);

   return f;
}

void key_free(Key *key) {
   if (!key)
     return;
   
   d_free(key->key);
   d_free(key->value);
   d_free(key);
}

char *construct_key(char *prog, char *h, char *k) {
   char *key;
   
   if (!prog || !h || !k)
     return NULL;
   
   d_msprintf(&key, "/%s/%s/%s", prog, h, k);
   
   return key;
}

char *breakdown_key(char *key, char **h, char **k, char **v) {
   char *lh, *lk, *lv;
   char *fptr, *dkey;
   
   if (!key || !h || !k)
     return 0;

   if (key[0] == '/')
     key++;
   
   fptr = d_strdup(key);
   dkey = fptr;
   
   /* skip program name */
   next_arg_full(dkey, &dkey, '/');
   
   lh = next_arg_full(dkey, &dkey, '/');
   lk = next_arg_full(dkey, &dkey, '=');

   lv = v ? last_arg(dkey, &dkey) : NULL;
   
   NA_RESET();

   if (!lk)
     return 0;

   *h = lh;
   *k = lk;
   
   if (v)
     *v = lv ? lv : NULL;
   
   return fptr;
}

char *is_header(char *line) {
   char *hdr;
   
   if (!line || line[0] != '[' || !strchr(line, ']'))
     return NULL;
   
   hdr = d_strdup(next_arg_full(line + 1, NULL, ']'));
   
   NA_RESET();
   
   return hdr;
}

GList *add_header(GList *keys, char *hdr) {
   GList *new_list = NULL;
   
   if (!hdr)
     return keys;

   new_list = g_list_append(new_list, d_strdup(hdr));
   
   keys = g_list_append(keys, new_list);
   
   return keys;
}

GList *find_key_header(GList *keys, char *h) {
   GList *ptr, *hdr;
   char *hs;
   
   for(ptr=keys; ptr; ptr=ptr->next) {
      hdr = ptr->data;
      if (!hdr)
	continue;
      
      hs = hdr->data;
      if (!hs)
	continue;
      
      if (!strcmp(hs, h))
	return ptr;
   }
   
   return NULL;
}

GList *add_key(GList *keys, char *h, char *k, char *v) {
   GList *flist;
   Key *key;

   if (!k || !v)
     return keys;
   
   if (!keys && !h)
     return keys;
   
   if (!h)
     flist = g_list_last(keys);
   else
     flist = find_key_header(keys, h);
   
   if (h && !flist) {
      keys = add_header(keys, h);
      flist = find_key_header(keys, h);
   }
   
   if (!flist || !flist->data)
     return keys;
   
   flist = flist->data;
   
   key = d_malloc(sizeof(Key));
   key->key = d_strdup(k);
   key->value = d_strdup(v);
   
   flist = g_list_append(flist, key);
   
   return keys;
}

GList *create_key_list() {
   FILE *f;
   GList *ptr, *felem, *keys;
   FileEntry *fent;
   char *line, *dptr, *hdr, *k, *v;
   
   keys = NULL;
   
   f = open_config("r");
   if (!f)
     return NULL;

   felem = read_file(f);

   fclose(f);

   keys = NULL;
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      line = last_arg(dptr, &dptr);
      
      if ((hdr = is_header(line))) {
	 keys = add_header(keys, hdr);
	 d_free(hdr);
      } else {
	 k = next_arg_full(line, &line, '=');
	 v = last_arg(line, &line);
	 
	 NA_RESET();

	 if (v)
	   keys = add_key(keys, NULL, k, v);
      }
   }
   
   read_file_free(felem);

   return keys;
}

Key *find_key(GList *hdr, char *key) {
   GList *ptr;
   Key *k;
   
   if (!key)
     return NULL;
   
   for(ptr=hdr->next; ptr; ptr=ptr->next) {
      k = ptr->data;
      if (!k)
	continue;
      
      if (!strcmp(k->key, key))
	return k;
   }
   
   return NULL;
}

void destroy_key_list(GList *keys) {
   GList *ptr, *child, *cptr;
   Key *key;
   
   if (!keys)
     return;
   
   for(ptr=keys; ptr; ptr=ptr->next) {
      child = ptr->data;
      if (!child)
	continue;
      
      if (child->data)
	d_free(child->data);
      
      child->data = NULL;
      
      for (cptr=child->next; cptr; cptr=cptr->next) {
	 key = cptr->data;
	 if (key)
	   key_free(key);
	 
	 cptr->data = NULL;
      }
      
      g_list_free(child);
   }
   
   g_list_free(keys);
}

Key *find_key_in_section(GList *keys, char *hdr, char *k) {
   Key *key;
   GList *sect;
   
   if (!keys)
     return NULL;
   
   sect = find_key_header(keys, hdr);
   if (!sect || !sect->data)
     return NULL;
   
   sect = sect->data;
   
   key = find_key(sect, k);
   
   return key;
}

char *j_config_access_read(char *key) {
   GList *keys;
   char *okey;
   char *header, *tkey, *value, *tv, *fptr;
   Key *k;
   
   if (!(fptr = breakdown_key(key, &header, &tkey, &value)))
     return NULL;

   keys = create_key_list();

   tv = NULL;

   k = find_key_in_section(keys, header, tkey);
   if (k && k->value)
     tv = strdup(k->value);
   else if (value) {
      okey = construct_key("gnapster", header, tkey);
      
      /* this is NOT how GNOME does it, but damnit, it should */
      j_config_set_string(okey, value);
      j_config_sync();
      
      tv = strdup(value);
      
      d_free(okey);
   }
   
   d_free(fptr);
   
   destroy_key_list(keys);

   return tv;
}

void j_config_access_write(char *key, char *value, int intval) {
   char *header, *tkey, *tv, *fptr;
   Key *k;
   
   if (!(fptr = breakdown_key(key, &header, &tkey, NULL)))
     return;

   /* this will be destroyed by j_config_sync ... if the call is 
    * omitted bad stuff will happen :) */
   if (!key_table)
     key_table = create_key_list();
   
   k = find_key_in_section(key_table, header, tkey);
   if (!k) {
      if (value)
	tv = d_strdup(value);
      else
	d_msprintf(&tv, "%i", intval);
      
      key_table = add_key(key_table, header, tkey, tv);
      
      d_free(tv);
   } else {
      d_free(k->value);
      if (value)
	k->value = d_strdup(value);
      else
	d_msprintf(&k->value, "%i", intval);
   }
   
   d_free(fptr);
}

void j_config_set_int(char *key, int val) {
#ifdef HAVE_GNOME
   gnome_config_set_int(key, val);
#else
   j_config_access_write(key, NULL, val);
#endif /* HAVE_GNOME */
}

void j_config_set_string(char *key, char *s) {
#ifdef HAVE_GNOME
   gnome_config_set_string(key, s);
#else
   j_config_access_write(key, s, 0);
#endif /* HAVE_GNOME */
}

char *j_config_get_string(char *key) {
#ifdef HAVE_GNOME
   return gnome_config_get_string(key);
#else
   char *r;

   r = j_config_access_read(key);
   
   return r;
#endif /* HAVE_GNOME */
}

int j_config_get_int(char *key) {
#ifdef HAVE_GNOME
   return gnome_config_get_int(key);
#else
   char *r;
   int ret;
   
   r = j_config_access_read(key);
   
   return (ret = my_atoi(r)) < 0 ? 0 : ret;
#endif /* HAVE_GNOME */
}

/* do something later maybe */
int j_config_has_section(char *key) {
#ifdef HAVE_GNOME
   return gnome_config_has_section(key);
#else
   return 1;
#endif /* HAVE_GNOME */
}

void j_config_sync() {
#ifdef HAVE_GNOME
   gnome_config_sync();
#else
   GList *ptr, *child, *cptr;
   FILE *f;
   Key *key;
   
   if (!key_table)
     return;
   
   f = open_config("w");
   if (!f)
     return;
   
   for(ptr=key_table; ptr; ptr=ptr->next) {
      child = ptr->data;
      if (!child)
	continue;
      
      /* print this sections header */
      fprintf(f, "[%s]\n", (char *)child->data);
      
      if (child->data)
	d_free(child->data);
      
      for(cptr=child->next; cptr; cptr=cptr->next) {
	 key = cptr->data;
	 if (!key)
	   continue;
	 
	 /* the keys in this section */
	 fprintf(f, "%s=%s\n", key->key, key->value);
	 
	 key_free(key);
      }
      
      /* padding */
      fprintf(f, "\n");
      
      g_list_free(child);
   }
   
   g_list_free(key_table);
   
   fclose(f);
   
   key_table = NULL;
#endif /* HAVE_GNOME */
}
