#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define __DEBUG_C

#define GLIB

#define GNAPSTER

#ifdef GLIB
#include <gtk/gtk.h>
#endif /* GLIB */


/* Don't enable this unless you know what you're doing :) */
/* #define MEMORY_DEBUG */

#define DEADBEEF ((void *)0xdeadbeef)

typedef struct {
   void *mem;
   unsigned int size;
   const char *file;
   int line;
} MemoryChunk;

void *dbg_free(const char *, int, void *);
void d_deadbeef(void *ptr, unsigned int size);
MemoryChunk *d_find_chunk(void *ptr);
#ifdef GNAPSTER
char *j_config_get_string(const char *key);
int struct_size(int t);
void set_type(void *, int t);
#endif /* GNAPSTER */

unsigned int total = 0;

#ifdef GLIB
GList *mem_list = NULL;
#else
List *mem_list = NULL;
#endif /* GLIB */

#define DEBUG __FILE__,__LINE__,

#if 0 /* MEMORY_DEBUG */
#define d_assert(exp) if (!(exp)) { fprintf(stderr, "%s, %s:%i: assertion failed: %s\n", __PRETTY_FUNCTION__,file,line,#exp); return NULL; }
#else
#define d_assert(exp) if (!(exp)) { return NULL; }
#define d_assert_return(exp,ret) if (!(exp)) { return ret; }
#endif

void d_warning(const char *file, int line, char *func, char *msg, void *mem) {
   fprintf(stderr, "%s(0x%08x, %s:%i): %s\n", func, (unsigned int)mem, 
	   file, line, msg);
}

void d_trace(const char *file, int line, char *func, int out) {
   fprintf(stderr, "%s:%i:\t%s()%s\n", 
	   file, line, func, out ? " out" : "");
}

void *d_memory_hunk_append(const char *file, int line, void *ptr, unsigned int size) {
#ifdef MEMORY_DEBUG
   MemoryChunk *chunk;
   
   d_assert(ptr != NULL);
   d_assert(size > 0);
   
   chunk = malloc(sizeof(MemoryChunk));
   d_assert(chunk != NULL);
   
   chunk->mem = ptr;
   chunk->size = size;
   chunk->file = file;
   chunk->line = line;
   
   total += chunk->size;
   
#ifdef GLIB
   mem_list = g_list_prepend(mem_list, chunk);
#else
   mem_list = list_add(mem_list, chunk);
#endif /* GLIB */
#endif
   
   return NULL;
}

char *d_config_get_string(const char *file, int line, const char *key) {
   char *ret;

   ret = j_config_get_string(key);
   d_assert(ret != NULL);

   d_memory_hunk_append(file, line, ret, strlen(ret) + 1);
   
   return ret;
}

void *d_hunk_remove(void *ptr) {
   MemoryChunk *chunk;
#ifdef GLIB
   GList *link;
#endif /* GLIB */
   
   chunk = d_find_chunk(ptr);
   
   d_assert(chunk != NULL);

#ifdef GLIB
   link = g_list_find(mem_list, chunk);
   mem_list = g_list_remove_link(mem_list, link); 
#else
   mem_list = list_remove(mem_list, chunk);
#endif /* GLIB */
   
   free(chunk);
   
   return chunk;
}

void *d_hunk_add(const char *file, int line, void *ptr, unsigned int size) {
   if (ptr == DEADBEEF)
     d_hunk_remove(ptr);
   
   d_memory_hunk_append(file, line, ptr, size);
   
   return NULL;
}

/* yes, i still hate C++ */
void *d_new(const char *file, int line, int t) {
   void *mem;
   size_t size;
   
   d_assert(t >= 0);
   
   size = struct_size(t);
   d_assert(size > 0);
   
   mem = malloc(size);
   d_assert(mem != NULL);
   
   d_memory_hunk_append(file, line, mem, size);
   
   memset(mem, 0, size);
   set_type(mem, t);
   
   return mem;
}

void *d_malloc(const char *file, int line, unsigned int size) {
   void *mem;
   
   d_assert(size > 0);
   
   mem = malloc(size);
   d_assert(mem != NULL);
   
   memset(mem, 0, size);

   d_memory_hunk_append(file, line, mem, size);
   
   return mem;
}

void *d_calloc(const char *file, int line, unsigned int size) {
   void *mem;

   d_assert(size > 0);
   
   mem = calloc(1, size);
   d_assert(mem != NULL);

   d_memory_hunk_append(file, line, mem, size);
   
   return mem;
}

char *d_strdup_vprintf(const char *file, int line, const char *s, va_list args) {
   char *mem;

   d_assert(s != NULL);
   
   mem = g_strdup_vprintf(s, args);
   d_assert(mem != NULL);
   
   d_memory_hunk_append(file, line, mem, strlen(mem) + 1);
   
   return mem;
}

#ifdef GLIB
char *d_str_expand(char **s, const char *fmt, ...) {
   va_list args;
   char *mem;
   
   d_assert(s != NULL);
   d_assert(fmt != NULL);
   
   va_start(args, fmt);
   mem = g_strdup_vprintf(fmt, args);
   va_end(args);
   
   d_assert(mem != NULL);
   
   dbg_free(DEBUG *s);

   d_deadbeef(mem, strlen(mem) + 1);
   
   *s = mem;
   
   return mem;
}
#endif /* GLIB */

#ifdef GLIB
char *d_strdup_printf(char **buf, const char *s, ...) {
   va_list args;
   char *mem;
   
   if (buf)
     *buf = NULL;

   d_assert(s != NULL);
   
   va_start(args, s);
   mem = g_strdup_vprintf(s, args);
   va_end(args);
   d_assert(mem != NULL);
   
   d_deadbeef(mem, strlen(mem) + 1);
/*   d_memory_hunk_append(file, line, mem, strlen(mem) + 1); */
   
   if (buf)
     *buf = mem;
   
   return mem;
}
#endif /* GLIB */

MemoryChunk *d_find_chunk(void *mem) {
   MemoryChunk *chunk;
#ifdef GLIB
   GList *ptr;
#else
   List *ptr;
#endif /* GLIB */
   
   for(ptr=mem_list; ptr; ptr=ptr->next) {
      chunk = ptr->data;
      if (!chunk)
	continue;
      
      if (chunk->mem == mem)
	return chunk;
   }
   
   return NULL;
}

void d_deadbeef(void *ptr, unsigned int size) {
#ifdef MEMORY_DEBUG
   MemoryChunk *chunk;
   
   chunk = d_find_chunk(DEADBEEF);
   if (chunk) {
      chunk->mem = ptr;
      chunk->size = size;
   }
#endif /* MEMORY_DEBUG */
}

void *d_realloc(const char *file, int line, void *ptr, unsigned int size) {
   void *mem;
#ifdef MEMORY_DEBUG
   MemoryChunk *chunk;
#ifdef GLIB
   GList *link;
#endif /* GLIB */
#endif /* MEMORY_DEBUG */
   
   d_assert(size > 0);
   
   mem = realloc(ptr, size);
   d_assert(mem != NULL);

#ifdef MEMORY_DEBUG
   chunk = d_find_chunk(ptr);

   if (chunk) {
#ifdef GLIB
      link = g_list_find(mem_list, chunk);
      mem_list = g_list_remove_link(mem_list, link);
#else
      mem_list = list_remove(mem_list, chunk);
#endif /* GLIB */
      
      free(chunk);
   }
#endif /* MEMORY_DEBUG */
   
   d_memory_hunk_append(file, line, mem, size);
   
   return mem;
}

void *dbg_free(const char *file, int line, void *ptr) {
   d_assert(ptr != NULL);
   
#ifdef MEMORY_DEBUG
   if (!d_hunk_remove(ptr))
     fprintf(stderr, "%s:%i: attempting to free uncontrolled memory 0x%08x\n", 
	     file, line, (unsigned int)ptr);
#endif /* MEMORY_DEBUG */
   
   free(ptr);
   
   return NULL;
}

int d_strcmp(const char *s1, const char *s2) {
   d_assert_return(s1, -1);
   d_assert_return(s2, -1);
   
   return strcmp(s1, s2);
}

char *d_strdup(const char *file, int line, const char *s) {
   char *mem;

   d_assert(s != NULL);
   
   mem = strdup(s);
   d_assert(mem != NULL);
   
   d_memory_hunk_append(file, line, mem, strlen(mem) + 1);
   
   return mem;
}

void d_summary_calc_data(MemoryChunk *chunk, int *r, int *a, unsigned int *s) {
#ifdef GLIB
   GList *ptr;
#else
   List *ptr;
#endif /* GLIB */
   MemoryChunk *c;
   int repeat = 0, avg;
   unsigned int size = 0;
   
   for(ptr=mem_list; ptr; ptr=ptr->next) {
      c = ptr->data;
      if (!strcmp(chunk->file, c->file) &&
	  chunk->line == c->line) {
	 repeat++;
	 size += chunk->size;
      }
   }

   avg = size / repeat;
   
   *r = repeat;
   *s = size;
   *a = avg;
}

void d_summary() {
#ifdef MEMORY_DEBUG
   MemoryChunk *chunk, *pchunk;
#ifdef GLIB
   GList *ptr, *pptr, *printed = NULL;
#endif /* GLIB */
   FILE *f;
   unsigned int total_unfreed = 0;
   int already_printed;
   
   f = get_file_handle();
   
   fprintf(f, "Non-freed stats\n");
   fprintf(f, "Address   \tFile         Line\tRepeat\tAvg  \tTotal Size\n");
   for(ptr=mem_list; ptr; ptr=ptr->next) {
      chunk = ptr->data;
      if (!chunk)
	continue;

      total_unfreed += chunk->size;
      for(pptr=printed, already_printed=0; pptr; pptr=pptr->next) {
	 pchunk = pptr->data;
	 if (!strcmp(chunk->file, pchunk->file) &&
	     chunk->line == pchunk->line)
	   already_printed = 1;
      }
      if (!already_printed) {
	 int repeat = -1, avg = -1;
	 unsigned int size = -1;
	 
	 d_summary_calc_data(chunk, &repeat, &avg, &size);
	 fprintf(f, "0x%08x\t%-12s %-3i\t%-3i\t%-3i\t%-3i\n", (unsigned int)chunk->mem,
		 chunk->file, chunk->line, repeat, avg, size);
#ifdef GLIB 
	 printed = g_list_append(printed, chunk);
#else
	 printed = list_append(printed, chunk);
#endif /* GLIB */
      }
   }
   
   fprintf(f, "total allocated: %i\n", total);
   fprintf(f, "total not freed: %i\n", total_unfreed);
   
   close_file_handle(f);
#endif
}
