#include "gnapster.h"

#include "browse.h"

int browse_results = 0;

extern GnapsterMain *gmain;

Search *browse_parse(STab *stab, char *data) {
   Search *s;
   char *file, *md5;
   unsigned long size, seconds;
   unsigned short bitrate, freq;
   
   file = next_arg(data, &data);
   md5 = next_arg(data, &data);
   convert(next_arg(data, &data), "%lu", &size);
   convert(next_arg(data, &data), "%hu", &bitrate);
   convert(next_arg(data, &data), "%hu", &freq);
   convert(next_arg(data, &data), "%lu", &seconds);
   
   NA_ERR_HANDLE(NULL);
   
   s = d_new(N_SEARCH);
   
   s->file = d_strdup(file);
   s->trunc_file = trunc_file(s->file);
/*   s->user = d_strdup("someguy"); */
   s->id = true_id(md5);
   s->num = seconds;
   s->size = size;
   s->kbps = bitrate;
   s->freq = freq;
   s->st = stab;
   
   return s;
}

void browse_request(STab *stab, char *user, int method) {
   ConnInfo *ci;
   
   if (!stab)
     return;
   
   /* disable direct browse */
   method = 0;
   
   ci = stab->ci;
   
   gmain->bt->nick = d_strdup(user);
   
   update_status(1, stab, _("Retrieving mp3 list..."), 1);
   ci->state |= BROWSING_MASK;
   
   if (method)
     napster_send(ci->sock, NAPSTER_PTP_BROWSE, "%s", user);
   else
     napster_send(ci->sock, NAPSTER_BROWSE, "%s", user);
         
   gtk_clist_clear(GTK_CLIST(gmain->bt->ctree));
   gtk_clist_freeze(GTK_CLIST(gmain->bt->ctree));
   gtk_entry_set_editable(GTK_ENTRY(gmain->bt->entry), 0);
   
/*   if (method)
     gmain->bt->timeout = TIMEOUT_ADD(30000, browse_request_old, stab);*/
}

void end_browse(STab *stab) {
   char *results;
   
   if (!browsing(stab->ci))
     return;
   
   d_free(gmain->bt->nick);
   gmain->bt->nick = NULL;
   
   update_status(1, stab, NULL, 0);
   
   gtk_entry_set_text(GTK_ENTRY(gmain->bt->entry), "");
   gtk_entry_set_editable(GTK_ENTRY(gmain->bt->entry), 1);
   
   gtk_ctree_sort_recursive(GTK_CTREE(gmain->bt->ctree), NULL);
   gtk_clist_thaw(GTK_CLIST(gmain->bt->ctree));
   
   if (g_list_length(GTK_CLIST(gmain->bt->ctree)->row_list) == 0)
     gnapster_clist_append(gmain->bt->ctree, stab->vbox, NULL,
			   "No mp3s found.", "", "", "", "", NULL);
   
   d_msprintf(&results, "%i", browse_results);
   gtk_clist_set_text(GTK_CLIST(gmain->bt->ctree), 0, 1, results);
   d_free(results);
   
   stab->ci->state &= ~BROWSING_MASK;
   browse_results = 0;
}

void bt_add(STab *stab, Search *b) {
   GtkCTreeNode *node, *nnode;
   
   /* this will create any nodes needed on it's way */
   node = find_bt_node(stab, b); 
   
   d_assert(node != NULL);
   
   /* add the leaf */
   nnode = insert_bt_leaf(stab, node, b);
   
   /* lets hack up the data so each node doesn't use more memory than 
    * is actually required */
   
   /* pushed into the tree itself as the root node */
   d_free(b->user);
   
   /* this will be duped into the tree as text, no need to store it here */
   d_free(b->file);
   
   /* so that search_free doesn't attempt to free these (as they normally
    * would exist) */
   b->user = b->file = NULL;

   gtk_ctree_node_set_row_data_full(GTK_CTREE(gmain->bt->ctree), nnode, b, 
				    (GtkDestroyNotify)gnapster_destroy);
}

GtkCTreeNode *find_bt_node(STab *stab, Search *b) {
   GtkCTreeNode *knode, *lnode = NULL;
   char *s, *ptr, *next = NULL;
   int key;
   
   s = b->file;
   
   /* path: #:\#\dir1\dir2\file.mp3 */
   
   convert(next_arg_full(s, &s, ':'), "%i", &key);
   
   d_assert_return(key > 0, NULL);
   
   /* get rid of \#\ */
   next_arg_full(s, &s, '\\');
   next_arg_full(s, &s, '\\');
   
   /* remaining path: dir1\dir2\file.mp3 */
   
   /* find the key node first */
   knode = find_bt_key_node(stab, key);

   lnode = knode;
   find_bt_last_node(stab, &lnode, GTK_CTREE_ROW(knode)->children, s, &next);
   
   s = next;
   
   /* remaining path: file.mp3 or ...\dir2\file.mp3 */
   
   if (!strchr(s, '\\'))
     return lnode;
   
   while((ptr = next_arg_full(s, &s, '\\'))) {
      char *text[4] = { ptr, NULL, NULL, NULL };
      
      lnode = gtk_ctree_insert_node(GTK_CTREE(gmain->bt->ctree), lnode, NULL, 
				    text, 0, NULL, NULL, NULL, NULL, 0, 0);
      
      /* don't add file.mp3! */
      if (!strchr(s, '\\'))
	break;
   }
   
   return lnode;
}

void find_bt_last_node(STab *stab, GtkCTreeNode **last, GtkCTreeNode *node, char *s, char **next) {
   char *ptr, *cmp;
   
   /* get the currently working path */
   d_free(*next);
   *next = d_strdup(s);
   
   /* get the next token to find */
   cmp = next_arg_full(s, &s, '\\');
   if (!cmp)
     return;

   for(; node; node=GTK_CTREE_ROW(node)->sibling) {
      /* manually get the text */
      ptr = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;
      
      if (strcmp(ptr, cmp))
	continue;
      
      /* hold a pointer to the last correctly identified node, this will
       * be used to determine how many nodes traversed were actually found,
       * the rest will be built manually */
      *last = node;
      
      /* more nasty gtk code */
      if (GTK_CTREE_ROW(node)->children)
	find_bt_last_node(stab, last, GTK_CTREE_ROW(node)->children, s, next);
   }
}

GtkCTreeNode *find_bt_key_node(STab *stab, int key) {
   GtkCTree *ctree;
   GtkCTreeNode *node;
   int *cmp_key;
   char *text[4];
   
   ctree = GTK_CTREE(gmain->bt->ctree);
   
   /* no need to recurse, the key is for the toplevel only */
   for(node=GTK_CTREE_NODE(GTK_CLIST(ctree)->row_list);
       node; node=GTK_CTREE_ROW(node)->sibling) {
      
      cmp_key = gtk_ctree_node_get_row_data(ctree, node);
      
      /* quick 4 byte compare */
      if (*cmp_key == key)
	return node;
   }
   
   memset(text, 0, sizeof(text));
   d_msprintf(&text[0], "%i", key);
   
   node = gtk_ctree_insert_node(ctree, NULL, NULL, text, 0, NULL, NULL, 
				NULL, NULL, 0, 0);
   
   cmp_key = d_malloc(sizeof(int));
   *cmp_key = key;
   
   gtk_ctree_node_set_row_data_full(ctree, node, cmp_key,
				    (GtkDestroyNotify)gnapster_destroy);
   
   d_free(text[0]);
   
   return node;
}

GtkCTreeNode *insert_bt_leaf(STab *stab, GtkCTreeNode *node, Search *b) {
   GtkCTreeNode *nnode, *sibling;
   char *text[4];
   
   text[0] = b->trunc_file;
   d_msprintf(&text[1], "%.02fM (%i:%02i)", ((float)b->size / 1024.0) / 1024.0,
	      b->num / 60, b->num % 60);
   d_msprintf(&text[2], "%hu", b->kbps);
   
   text[3] = NULL;
   
   sibling = GTK_CTREE_ROW(node)->children ? 
     GTK_CTREE_ROW(node)->children : NULL;
   
   nnode = gtk_ctree_insert_node(GTK_CTREE(gmain->bt->ctree), node, sibling,
				 text, 0, NULL, NULL, NULL, NULL, 1, 0);
   
   d_free(text[1]);
   d_free(text[2]);
   
   return nnode;
}
