-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/lista4/lista4.adb,v $
--  Description     : binding package
--  Author          : Julio Cano                                             --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: jukano $
--  Last Modified On: $Date: 2002/01/22 18:57:34 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Julio Cano                                            --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Julio Cano  <julius_bip@yahoo.com>                               --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Pgrecordset;
with text_io;

procedure Lista4 is
   package Db renames Pgrecordset;


   Conx : Db.Pgrecordset_Ptr;

   name : aliased String(1..20);
   salary : aliased String (1..13);
   date : aliased String(1..35);

begin


   Conx := Db.Recordset_New("DEMO_DB","gnade");

   db.registerdata (Conx, name'Unrestricted_access, "name");
   db.query (conx, "select * from employees");
   db.registerdata (Conx, salary'Unrestricted_access, "salary");
   db.registerdata (Conx, date'Unrestricted_access, "since");
   db.movefirst(conx);

   Text_Io.Put_Line("NAME                SALARY       SINCE");
   declare
      fin : boolean := false;
   begin
      loop
         text_io.put (Name);
         text_io.put (Salary);
         text_io.put_line (Date);
         db.movenext(conx);
         exit when Fin;
      end loop;
   exception
      when db.no_data => fin := true;
      when others => text_io.put_line ("Unhandled exception.");
   end;

   begin
      Db.Recordset_Close (Conx);
   exception
      when others => Text_Io.Put_Line ("!!!!!!!");
   end;

end Lista4;
