--- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/Makefile
--  Description     : Database layer                                          --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-April-2005                                          --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/01/21 08:48:34 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006 Michael Erdmann                                       --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE;  see file COPYING. If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with SQL_Standard;			use SQL_Standard;

package Objects is

   Blob_Size           : constant Positive := 10_000;
   Key_Size            : constant Positive := 17;

   Lowest_Version      : constant Integer := -1;
   Highest_Version     : constant Integer := -2;
   New_Version         : constant Integer := -3;
   All_Versions        : constant Integer := -4;
   Current_Version     : constant Integer := -5;

   Insert_Failed       : exception;
   Object_Not_Existing : exception;
   Invalid_Arguments   : exception;
   Relation_Exists     : exception;
   To_Many_Objects     : exception;

   ---------------------------------------------------------------------------
   -- Description:
   -- Preconditions:
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   ---------------------------------------------------------------------------
   procedure Insert_Object(
      Object_ID      : in Integer;
      Object_Version : in out Integer;
      BLOB           : in GNADE.BINARY;
      Hash_Value     : in GNADE.BINARY;
      Class_Name     : in String );

   ---------------------------------------------------------------------------
   -- Description:
   -- Preconditions:
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   ---------------------------------------------------------------------------
   procedure Get_Object(
      Object_ID      : in Integer;
      Object_Version : in out Integer ;
      BLOB           : out GNADE.BINARY;
      Length         : out Positive);

    procedure Get_Object(
      Key            : in GNADE.BINARY;
      Object_Version : in out Integer ;
      Object_ID      : out Integer;
      BLOB           : out GNADE.BINARY;
      Length         : out Positive);

   ---------------------------------------------------------------------------
   -- Description:
   -- Preconditions:
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   ---------------------------------------------------------------------------
   procedure Delete_Object(
      Object_ID      : in Integer;
      Object_Version : in Integer := Highest_Version );

  ---------------------------------------------------------------------------
   -- Description:
   -- Preconditions:
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   ---------------------------------------------------------------------------
   function Rootname(
      Name : in String ) return Integer;

   procedure Rootname(
      Name      : in String;
      Object_ID : in Integer );

   ---------------------------------------------------------------------------
   -- Description:
   -- Preconditions:
   -- Postconditions:
   -- Exceptions:
   -- Notes:
   ---------------------------------------------------------------------------
   procedure Relate(
       Source_ID : in Integer;
       Target_ID : in Integer;
       Rel_Name  : in String );

   procedure Unrelate(
      Source_ID : in Integer;
      Target_ID : in Integer;
      Rel_Name  : in String );

   procedure Unrelate(
      Source_ID : in Integer;
      Rel_Name  : in String );

   type OID_Array_Type is array( Natural range <> ) of Integer;

   procedure Get_Related(
      Object_ID : in Integer;
      Rel_Name  : in String;
      Objects   : in out OID_Array_Type;
      Length    : out Integer );

   procedure Get_References(
      Object_ID : in Integer;
      Rel_Name  : in String;
      Objects   : in out OID_Array_Type;
      Length    : out Integer );

   procedure Connect;

end Objects;


