------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-date.adb,v 1.3 2003/11/27 12:34:00 vagul Exp $

with OCI.Lib;
with OCI.Thread;
with Interfaces.C;
with OCI.Environments;

package body OCI.Thick.Date is

   use Lib;

   -------------
   -- Compare --
   -------------

   function Compare (Left, Right : OCIDate) return Compare_Result is
      Result : aliased SWord;
      Rc :  SWord := OCIDateCompare
        (Err => Thread.Error,
         Date1 => Left,
         Date2 => Right,
         Result => Result'Access);
   begin
      Check_Error (Rc);
      return Compare_Result (Result);
   end Compare;

   function "<" (Left, Right : OCIDate) return Boolean is
   begin
      return Compare (Left, Right) = -1;
   end "<";

   function ">" (Left, Right : OCIDate) return Boolean is
   begin
      return Compare (Left, Right) = 1;
   end ">";

   function Equal (Left, Right : OCIDate) return Boolean is
   begin
      return Compare (Left, Right) = 0;
   end Equal;

   function "<=" (Left, Right : OCIDate) return Boolean is
   begin
      return Compare (Left, Right) /= 1;
   end "<=";

   function ">=" (Left, Right : OCIDate) return Boolean is
   begin
      return Compare (Left, Right) /= -1;
   end ">=";

   -------------
   -- SysDate --
   -------------

   function SysDate return OCIDate is
      Result : aliased OCIDate;
      Rc :  Sword := OCIDateSysDate (Err => Thread.Error,
         Date => Result'access);
   begin
      Check_Error (Rc);
      return Result;
   end SysDate;

   -------------
   -- To_Date --
   -------------

   function To_Date (Item : String; Format : String) return OCIDate is
      Result : aliased OCIDate;
      RC : SWord := OCIDateFromText
              (Err          => Thread.Error,
               Date_Str     => C.To_C (Item),
               d_Str_Length => Item'Length,
               Fmt          => C.To_C (Format),
               Fmt_Length   => Format'Length,
               Lang_Name    => CStr.Null_Ptr,
               Lang_Length  => 0,
               Date         => Result'Access);
   begin
      Check_Error (Rc);
      return Result;
   end To_Date;

   ---------------
   -- To_String --
   ---------------

   function To_String (From : OCIDate; Format : String) return String is
      use Interfaces.C;
      Buff : aliased Text := (0 .. Format'Length + 64 => C.nul);
      Len  : aliased Ub4 := Buff'Length - 1; 
      Rc   : Sword := OCIDateToText
        (Err         => Thread.Error,
         Date        => From,
         Fmt         => C.To_C (Format),
         Fmt_Length  => Format'Length,
         Lang_Name   => CStr.Null_Ptr,
         Lang_Length => 0,
         Buf_Size    => Len'access,
         Buf         => CStr.To_Chars_Ptr (Buff'Unchecked_Access));
   begin
      Check_Error (Rc);
      return C.To_Ada (Buff, False) (1 .. Integer (Len));
   end To_String;

begin
   OCI.Environments.Set_Create_Mode_Flag (OCI_OBJECT);
end OCI.Thick.Date;
