#!/bin/sh
## ----------------------------------------------------------------------------
##                                                                           --
##                      GNADE  : GNu Ada Database Environment                --
##                                                                           --
##  Filename        : $Source: /cvsroot/gnade/gnade/bin/staticlib.sh.in,v $  --
##  Description     : remove the include files from the build                --
##  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>	     --
##  Created On      : 28-Feb-2004					     --
##  Last Modified By: $Author: merdmann $				     --
##  Last Modified On: $Date: 2002/08/31 15:20:37 $			     --
##  Status          : $State: Exp $					     --
##				                                             --
##  Copyright (C) 2000-2004 M.Erdmann                                        --
##                                                                           --
##  GNADE is copyrighted by the persons and institutions enumerated in the   --
##  AUTHORS file. This file is located in the root directory of the          --
##  GNADE distribution.                                                      --
##                                                                           --
##  GNADE is free software;  you can redistribute it  and/or modify it under --
##  terms of the  GNU General Public License as published  by the Free Soft- --
##  ware  Foundation;  either version 2,  or (at your option) any later ver- --
##  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
##  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
##  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
##  for  more details.  You should have  received  a copy of the GNU General --
##  Public License  distributed with GNAT;  see file COPYING.  If not, write --
##  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
##  MA 02111-1307, USA.                                                      --
##                                                                           --
##  As a special exception,  if other files  instantiate  generics from      --
##  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
##  files  to produce an executable, these  units or libraries do not by     --
##  itself cause the resulting  executable  to  be covered  by the  GNU      --
##  General  Public  License.  This exception does not however invalidate    --
##  any other reasons why  the executable file  might be covered by the      --
##  GNU Public License.                                                      --
##                                                                           --
##  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
##                                                                           --
## ----------------------------------------------------------------------------

includedir="/tmp"
opt_clean="n"

##
##
##
usage()
{
	cat <<EOF
Usage: staticlib.sh [OPTIONS] <name>
Options:
	[--include=<targetdir> ]
	[--clean] 

Description:
This script copies the package specifications after compilation
into the specified directory and changes the file permissions in
such a way that the gnat compiler assumes predefined units.

EOF
	exit $1
}

##
## deleteunit
##
deleteunit() {
   t=$2/`basename $1` 
   if test -f $t ; then
      chmod 0666 $t
      rm $t
   fi
}

## ########################################## ##
##            Main Entry                      ##
## ########################################## ##

if test $# -eq 0; then
   usage 1 1>&2
   exit 1;
fi
##
## Scan the arguments
##
includedir=$1
shift

for i in $* ; do
   deleteunit $i $includedir
done

##
exit 0
## ################## ##
## #    E X I T     # ##
## ################## ##
