#!/bin/sh
## ----------------------------------------------------------------------------
##                                                                           --
##                      GNADE  : GNu Ada Database Environment                --
##                                                                           --
##  Filename        : $Source: /cvsroot/gnade/gnade/bin/sharedlib.sh,v $
##  Description     : build and install shared libs in the system            --
##  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
##  Created On      : 9-April-2002                                           --
##  Last Modified By: $Author: merdmann $                                    --
##  Last Modified On: $Date: 2004/03/01 06:52:42 $                           --
##  Status          : $State: Exp $                                          --
##                                                                           --
##  Copyright (C) 2000-2004                                                  --
##                                                                           --
##  GNADE is copyrighted by the persons and institutions enumerated in the   --
##  AUTHORS file. This file is located in the root directory of the          --
##  GNADE distribution.                                                      --
##                                                                           --
##  GNADE is free software;  you can redistribute it  and/or modify it under --
##  terms of the  GNU General Public License as published  by the Free Soft- --
##  ware  Foundation;  either version 2,  or (at your option) any later ver- --
##  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
##  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
##  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
##  for  more details.  You should have  received  a copy of the GNU General --
##  Public License  distributed with GNAT;  see file COPYING.  If not, write --
##  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
##  MA 02111-1307, USA.                                                      --
##                                                                           --
##  As a special exception,  if other files  instantiate  generics from      --
##  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
##  files  to produce an executable, these  units or libraries do not by     --
##  itself cause the resulting  executable  to  be covered  by the  GNU      --
##  General  Public  License.  This exception does not however invalidate    --
##  any other reasons why  the executable file  might be covered by the      --
##  GNU Public License.                                                      --
##                                                                           --
##  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
##                                                                           --
## ----------------------------------------------------------------------------

opt_clean="n"

srcdir=""
libname=""
libdir=""
MAJOR=""
MINOR=""
##
##
##
usage()
{
	cat <<EOF
Usage: sharedlib.sh <libdir> <minor> <major> <name(s)>
Description:
Creates a shred library with all object which are stored in the $libdir 
directory.
EOF
	exit $1
}

##
## Create a shared library and 
##
makeshared() {
   target=$libdir/$1.$MAJOR
   case `uname` in
      Darwin* | darwin )
	   ( cd $libdir; 
	     libtool -dynamic $srcdir/*.o -o $target -L/usr/lib/ada -lgnat /usr/lib/libiodbc.dylib /Library/MySQL/lib/mysql/libmysqlclient.dylib -noall_load  -lsystem -lgcc )
	   ;;
      *)
	   ( cd $libdir; gcc -shared -o $target  $srcdir/*.o )
	   ;;
   esac

   ( cd $libdir && ln -sf $target $target.$MINOR )
   ( cd $libdir && chmod 0555 $target $target.$MINOR )

}

## ########################################## ##
##            Main Entry                      ##
## ########################################## ##

if test $# -eq 0; then
   usage 1 1>&2
   exit 1;
fi
##
## Scan the arguments
##
srcdir=`pwd`
libdir=$1
shift
MINOR=$1
shift
MAJOR=$1
shift
makeshared $1


##
exit 0
## ################## ##
## #    E X I T     # ##
## ################## ##  
