#include <glib-object.h>
#include <glib.h>
#include <gmyth/gmyth.h>

#include "common.h"

int
main(int args, const char **argv)
{
    const char     *uri = argv[1];
    GMythURI       *gmyth_uri = NULL;
    gboolean        res;
    GMythBackendInfo *backend_info = NULL;
    g_type_init();
    g_thread_init(NULL);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    backend_info = gmyth_backend_info_new();
    gmyth_uri = gmyth_uri_new_with_value(uri);

    gmyth_backend_info_set_hostname(backend_info,
                                    gmyth_uri_get_host(gmyth_uri));
    gmyth_backend_info_set_port(backend_info,
                                gmyth_uri_get_port(gmyth_uri));

    res = gmyth_util_file_exists(backend_info, uri);
    if (res == FALSE) {
        g_debug("file not exists");
        return -1;
    }
    GMythFileTransfer *file_transfer =
        gmyth_file_transfer_new(backend_info);
    GString        *hostname = g_string_new(uri);
    res = gmyth_file_transfer_open(file_transfer, uri);
    if (res == FALSE) {
        g_debug("Fail to open server");
        return -1;
    }

    gint64          filesize =
        gmyth_file_transfer_get_filesize(file_transfer);
    if (filesize <= 0) {
        g_debug("filesize is 0");
        return -1;
    }

    GByteArray     *data = g_byte_array_new();
    guint           num =
        gmyth_file_transfer_read(file_transfer, data, filesize, FALSE);
    g_debug("read %d bytes", num);

    if (data != NULL)
        g_byte_array_free(data, TRUE);
    if (file_transfer != NULL)
        g_object_unref(file_transfer);
    if (gmyth_uri != NULL)
        g_object_unref(gmyth_uri);
    if (hostname != NULL)
        g_string_free(hostname, TRUE);

    return (0);
}
