/*
 *  Copyright 2004-2006 Michael Terry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "CharBox.h"
#include "config.h"
#include "gettext.h"
#include <gdkmm.h>


void CharBox::setup (const char *str, bool border)
{
	if (border) {
		Glib::RefPtr<const Gtk::Style> style;
		
		/* Create a smaller eventbox inside us */
		inner = manage (new Gtk::EventBox ());
		inner->set_border_width (1);
		add (*inner);
		
		/* Make this eventbox black to create a border */
		this->ensure_style ();
		style = this->get_style ();
		this->modify_bg (this->get_state (), style->get_text (this->get_state ()));
	}
	else
	{
		inner = this;
	}
	
	this->string = str;
	
	inner->signal_size_allocate ().connect (sigc::mem_fun (*this, &CharBox::size_allocated));
	inner->signal_expose_event ().connect (sigc::mem_fun (*this, &CharBox::exposed));
	
	layout = inner->create_pango_layout (this->string);
}

CharBox::CharBox (char c, bool border)
{
	char cstr[2];
	cstr[0] = c;
	cstr[1] = 0;
	setup (cstr, border);
}

CharBox::CharBox (const char *str, bool border)
{
	setup (str, border);
}

void CharBox::size_allocated (Gdk::Rectangle& allocation)
{
	Glib::ustring s;
	char hstr[10];
	int points, dpi;
	
	/* Convert pixel space to desired point size */
	this->get_screen ()->get_setting ("gtk-xft-dpi", dpi);
	dpi /= PANGO_SCALE;
	points = (int) ((allocation.get_height () - 8) * (72.0/dpi));
	sprintf (hstr, "%i", points);
	
	s = "<span font_desc=\"";
	s += hstr;
	s += "\">";
	s += _(this->string.c_str ());
	s += "</span>";
	
	this->layout->set_markup (s);
}

bool CharBox::exposed (GdkEventExpose *event)
{
	int lwidth, lheight, xoffset, yoffset;
	Gdk::Rectangle allocation;
	
	/* Center text */
	this->layout->get_pixel_size (lwidth, lheight);
	allocation = inner->get_allocation ();
	xoffset = (allocation.get_width () - lwidth) / 2;
	yoffset = (allocation.get_height () - lheight) / 2;
	
	/* Draw it */
	inner->get_window ()->draw_layout (inner->get_style ()->get_fg_gc (inner->get_state ()), xoffset, yoffset, this->layout);
	
	return false;
}
