#ifndef HWCODE_H
#define HWCODE_H

__inline__ WORD inb(unsigned short port);
__inline__ WORD inl(unsigned short port);
__inline__ WORD outb(unsigned short port, BYTE val);
__inline__ WORD outw(unsigned short port, unsigned short val);
__inline__ WORD outl(unsigned short port, WORD val);
long endMGA(long ret);

#define innb(i,v) inb(i)
#define innl(i,v) inl(i)

#define PCI(f,i,v) ( outl(0xCF8, (addr) | ((i) & ~3)), endMGA(f(0xCFC | ((i) & 3), (v))) )
#define REG(f,i,v) ( PCI(outw, 0x44,   (i)), PCI(f, 0x48 | ((i) & 3), (v)) )
#define DAC(f,i,v) ( REG(outb, 0x3C00, (i)), REG(f, 0x3C0A, (v)) )


#define inl_pci(i)       PCI(innl, i, 0)
#define outl_pci(i, v)   PCI(outl, i, v)
#define out_dac(i,v)     DAC(outb, i, v)
#define in_dac(i)        DAC(innb, i, 0)
#define outb_reg(i,v)    REG(outb, i, v)
#define inb_reg(i)       REG(innb, i, 0)

#endif
