#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <ctype.h>
#include <time.h>

#include "support.h"
#include "mfsk.h"
#include "qsodata.h"
#include "macro.h"
#include "prefs.h"
#include "interface.h"

#define	SOFTSTRING	"gMFSK v" VERSION " (Gnome MFSK) by OH2BNS"

const gchar *timeformat = "%H:%M:%S %Z";
const gchar *dateformat = "%d.%m.%Y";

#define confcpy(d,s)	{ strncpy((d),(s),sizeof(d)); d[sizeof(d)-1] = 0; }

static GtkWidget *macroconfigwin = NULL;   

/* ---------------------------------------------------------------------- */

static void set_macro_button_names(void)
{
	GtkButton *button;
	GtkLabel *label;
	gchar buf[32];
	gint i;

	for (i = 0; i < NUMMACROS; i++) {
		sprintf(buf, "macrobutton%d", i + 1);

		button = GTK_BUTTON(lookup_widget(appwindow, buf));
		label = GTK_LABEL(GTK_BIN(button)->child);

		gtk_label_set_text(label, prefs.macros[i].name);
	}
}

/* ---------------------------------------------------------------------- */

static void fill_macroconfig(GtkWidget *win, gint n)
{
	GtkEntry *entry;
	GtkText *text;
	gchar buf[10];

	/* should not happen... */
	if (n < 1 || n > NUMMACROS) {
		g_print("fill_macroconfig: invalid macro number %d\n", n);
		return;
	}

	sprintf(buf, "macro %d", n);
	gtk_window_set_title(GTK_WINDOW(win), buf);

	entry = GTK_ENTRY(lookup_widget(win, "macroconfigentry"));
	gtk_entry_set_text(entry, prefs.macros[n - 1].name);

	text = GTK_TEXT(lookup_widget(win, "macroconfigtext"));
	gtk_text_insert(text, NULL, NULL, NULL, prefs.macros[n - 1].text, -1);
}

static void apply_macroconfig(GtkWidget *win)
{
	GtkEditable *editable;
	gchar buf[64];
	gchar *s;
	gint n;

	/* the window title is "macro n" */
	n = atoi(GTK_WINDOW(win)->title + 6);

	if (n < 1 || n > NUMMACROS) {
		g_print("apply_macroconfig: invalid macro number %d\n", n);
		return;
	}

	editable = GTK_EDITABLE(lookup_widget(win, "macroconfigentry"));
	s = gtk_editable_get_chars(editable, 0, -1);
	strncpy(prefs.macros[n - 1].name, s, 16);
	prefs.macros[n - 1].name[15] = 0;
	g_free(s);

	editable = GTK_EDITABLE(lookup_widget(win, "macroconfigtext"));
	s = gtk_editable_get_chars(editable, 0, -1);
	g_free(prefs.macros[n - 1].text);
	prefs.macros[n - 1].text = s;

	sprintf(buf, "/gmfsk/macro/name%d", n);
	gnome_config_set_string(buf, prefs.macros[n - 1].name);

	sprintf(buf, "/gmfsk/macro/text%d", n);
	gnome_config_set_string(buf, prefs.macros[n - 1].text);

	gnome_config_sync();

	set_macro_button_names();
}

/* ---------------------------------------------------------------------- */

void macroconfig_load(void)
{
	gchar *p;

	p = gnome_config_get_string("/gmfsk/macro/name1=" MACRODEF1NAME);
	confcpy(prefs.macros[0].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text1=" MACRODEF1TEXT);
	prefs.macros[0].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name2=" MACRODEF2NAME);
	confcpy(prefs.macros[1].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text2=" MACRODEF2TEXT);
	prefs.macros[1].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name3=" MACRODEF3NAME);
	confcpy(prefs.macros[2].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text3=" MACRODEF3TEXT);
	prefs.macros[2].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name4=" MACRODEF4NAME);
	confcpy(prefs.macros[3].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text4=" MACRODEF4TEXT);
	prefs.macros[3].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name5=" MACRODEF5NAME);
	confcpy(prefs.macros[4].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text5=" MACRODEF5TEXT);
	prefs.macros[4].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name6=" MACRODEF6NAME);
	confcpy(prefs.macros[5].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text6=" MACRODEF6TEXT);
	prefs.macros[5].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name7=" MACRODEF7NAME);
	confcpy(prefs.macros[6].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text7=" MACRODEF7TEXT);
	prefs.macros[6].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name8=" MACRODEF8NAME);
	confcpy(prefs.macros[7].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text8=" MACRODEF8TEXT);
	prefs.macros[7].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name9=" MACRODEF9NAME);
	confcpy(prefs.macros[8].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text9=" MACRODEF9TEXT);
	prefs.macros[8].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name10=" MACRODEF10NAME);
	confcpy(prefs.macros[9].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text10=" MACRODEF10TEXT);
	prefs.macros[9].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name11=" MACRODEF11NAME);
	confcpy(prefs.macros[10].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text11=" MACRODEF11TEXT);
	prefs.macros[10].text = p;

	p = gnome_config_get_string("/gmfsk/macro/name12=" MACRODEF12NAME);
	confcpy(prefs.macros[11].name, p);
	g_free(p);
	p = gnome_config_get_string("/gmfsk/macro/text12=" MACRODEF12TEXT);
	prefs.macros[11].text = p;

	set_macro_button_names();
}

/* ---------------------------------------------------------------------- */

void macroconfig(gint n)
{
	if (macroconfigwin)
		return;

	macroconfigwin = create_macroconfigwindow();
	fill_macroconfig(macroconfigwin, n);
	gtk_widget_show(macroconfigwin);
}

void macroconfig_clear(void)
{
	GtkEditable *editable;

	if (!macroconfigwin)
		return;

	editable = GTK_EDITABLE(lookup_widget(macroconfigwin,
					      "macroconfigentry"));

	gtk_editable_delete_text(editable, 0, -1);

	editable = GTK_EDITABLE(lookup_widget(macroconfigwin,
					      "macroconfigtext"));

	gtk_editable_delete_text(editable, 0, -1);
}

void macroconfig_close(gboolean save)
{
	if (!macroconfigwin)
		return;

	if (save == TRUE)
		apply_macroconfig(macroconfigwin);

	gtk_widget_destroy(macroconfigwin);
	macroconfigwin = NULL;
}

void macroconfig_delete(void)
{
	macroconfigwin = NULL;
}

/* ---------------------------------------------------------------------- */

void push_button(const gchar *name)
{
	GtkToggleButton *button;

	button = GTK_TOGGLE_BUTTON(lookup_widget(appwindow, name));
	gtk_toggle_button_set_active(button, TRUE);
}

void send_char(const gchar c)
{
	GtkText *text;

	text = GTK_TEXT(lookup_widget(appwindow, "txtext"));

	gtk_text_backward_delete(text, 1);
	gtk_text_insert(text, NULL, NULL, NULL, &c, 1);
	gtk_text_insert(text, NULL, NULL, NULL, "_", -1);

	typeahead_put_char(c);
}

void send_string(gchar *str)
{
	GtkText *text;

	text = GTK_TEXT(lookup_widget(appwindow, "txtext"));

	gtk_text_backward_delete(text, 1);
	gtk_text_insert(text, NULL, NULL, NULL, str, -1);
	gtk_text_insert(text, NULL, NULL, NULL, "_", -1);

	typeahead_put_string(str);
}

/* ---------------------------------------------------------------------- */

static gchar *getword(const gchar *str)
{
	static gchar buf[256], *p;
	gint len = 0;

	p = buf;
	*p++ = *str++;	/* copy the '$' */

	while (*str && isalnum(*str) && len++ < sizeof(buf) - 1)
		*p++ = *str++;

	*p = 0;

	return buf;
}

void send_macro(gint n)
{
	gchar *p, *word, buf[64];
	struct tm *tm;
	time_t t;

	/* should not happen... */
	if (n < 1 || n > NUMMACROS) {
		g_print("send_macro: invalid macro number %d\n", n);
		return;
	}

	p = prefs.macros[n - 1].text;

	while (p && *p) {
		if (*p == '$') {
			word = getword(p);

			if (!strcasecmp(word, "$$")) {
				send_char('$');
				p += 2;
				continue;
			}

			if (!strcasecmp(word, "$tx")) {
				push_button("txbutton");
				p += 3;
				continue;
			}

			if (!strcasecmp(word, "$rx")) {
				push_button("rxbutton");
				p += 3;
				continue;
			}

			if (!strcasecmp(word, "$pause")) {
				push_button("pausebutton");
				p += 6;
				continue;
			}

			if (!strcasecmp(word, "$abort")) {
				push_button("abortbutton");
				p += 6;
				continue;
			}

			if (!strcasecmp(word, "$mycall")) {
				send_string(prefs.mycall);
				p += 7;
				continue;
			}

			if (!strcasecmp(word, "$myname")) {
				send_string(prefs.myname);
				p += 7;
				continue;
			}

			if (!strcasecmp(word, "$myqth")) {
				send_string(prefs.myqth);
				p += 6;
				continue;
			}

			if (!strcasecmp(word, "$myloc")) {
				send_string(prefs.myloc);
				p += 6;
				continue;
			}

			if (!strcasecmp(word, "$myemail")) {
				send_string(prefs.myemail);
				p += 8;
				continue;
			}

			if (!strcasecmp(word, "$time")) {
				time(&t);
				tm = localtime(&t);
				strftime(buf, sizeof(buf), timeformat, tm);
				buf[sizeof(buf) - 1] = 0;
				send_string(buf);
				p += 5;
				continue;
			}

			if (!strcasecmp(word, "$utctime")) {
				time(&t);
				tm = gmtime(&t);
				strftime(buf, sizeof(buf), timeformat, tm);
				buf[sizeof(buf) - 1] = 0;
				send_string(buf);
				p += 8;
				continue;
			}

			if (!strcasecmp(word, "$date")) {
				time(&t);
				tm = localtime(&t);
				strftime(buf, sizeof(buf), dateformat, tm);
				buf[sizeof(buf) - 1] = 0;
				send_string(buf);
				p += 5;
				continue;
			}

			if (!strcasecmp(word, "$utcdate")) {
				time(&t);
				tm = gmtime(&t);
				strftime(buf, sizeof(buf), dateformat, tm);
				buf[sizeof(buf) - 1] = 0;
				send_string(buf);
				p += 8;
				continue;
			}

			if (!strcasecmp(word, "$call")) {
				send_string(get_qsocall());
				p += 5;
				continue;
			}

			if (!strcasecmp(word, "$band")) {
				send_string(get_qsoband());
				p += 5;
				continue;
			}

			if (!strcasecmp(word, "$rxrst")) {
				send_string(get_qsorxrst());
				p += 6;
				continue;
			}

			if (!strcasecmp(word, "$txrst")) {
				send_string(get_qsotxrst());
				p += 6;
				continue;
			}

			if (!strcasecmp(word, "$name")) {
				send_string(get_qsoname());
				p += 5;
				continue;
			}

			if (!strcasecmp(word, "$qth")) {
				send_string(get_qsoqth());
				p += 4;
				continue;
			}

			if (!strcasecmp(word, "$notes")) {
				send_string(get_qsonotes());
				p += 6;
				continue;
			}

			if (!strcasecmp(word, "$soft")) {
				send_string(SOFTSTRING);
				p += 5;
				continue;
			}

			/* no matching macro found -- fall through */
		}

		send_char(*p++);
	}
}

/* ---------------------------------------------------------------------- */

