/*
  File autogenerated by gengetopt version 2.13
  generated with the following command:
  gengetopt --input=../tools/gliv.ggo --unamed-opts --no-handle-error 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->add_all_given = 0 ;
  args_info->recursive_given = 0 ;
  args_info->sort_given = 0 ;
  args_info->shuffle_given = 0 ;
  args_info->force_load_given = 0 ;
  args_info->client_given = 0 ;
  args_info->build_menus_given = 0 ;
  args_info->glivrc_given = 0 ;
  args_info->slide_show_given = 0 ;
  args_info->null_given = 0 ;
  args_info->collection_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->add_all_arg = NULL;
  args_info->recursive_arg = NULL;
  args_info->sort_arg = NULL;
  args_info->shuffle_arg = NULL;
  args_info->force_load_arg = NULL;
  args_info->client_arg = NULL;
  args_info->build_menus_arg = NULL;
  args_info->glivrc_arg = NULL;
  args_info->slide_show_arg = NULL;
  args_info->null_arg = NULL;
  args_info->collection_arg = NULL;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n%s\n", "Image Viewer using OpenGL");
  printf("\nUsage: %s [OPTIONS]... [FILES]...\n\n", CMDLINE_PARSER_PACKAGE);
  printf("%s\n","  -h, --help                  Print help and exit");
  printf("%s\n","  -V, --version               Print version and exit");
  printf("%s\n","  -a, --add-all[=on|off]      Add all files in the directory");
  printf("%s\n","  -R, --recursive[=on|off]    Recursive directory traversal");
  printf("%s\n","  -S, --sort[=on|off]         Show images in sorted order");
  printf("%s\n","  -s, --shuffle[=on|off]      Show images in random order");
  printf("%s\n","  -F, --force-load[=on|off]   Try to load every file");
  printf("%s\n","  -C, --client[=on|off]       Connect to an already running gliv");
  printf("%s\n","  -e, --build-menus[=on|off]  No images menu at startup");
  printf("%s\n","  -g, --glivrc[=FILE]         Use this configuration file or none");
  printf("%s\n","  -w, --slide-show[=on|off]   Start the slide show immediately");
  printf("%s\n","  -0, --null[=on|off]         Read null-terminated filenames");
  printf("%s\n","  -o, --collection[=FILE]     Output a collection");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->add_all_arg)
    {
      free (args_info->add_all_arg); /* free previous argument */
      args_info->add_all_arg = 0;
    }
  if (args_info->recursive_arg)
    {
      free (args_info->recursive_arg); /* free previous argument */
      args_info->recursive_arg = 0;
    }
  if (args_info->sort_arg)
    {
      free (args_info->sort_arg); /* free previous argument */
      args_info->sort_arg = 0;
    }
  if (args_info->shuffle_arg)
    {
      free (args_info->shuffle_arg); /* free previous argument */
      args_info->shuffle_arg = 0;
    }
  if (args_info->force_load_arg)
    {
      free (args_info->force_load_arg); /* free previous argument */
      args_info->force_load_arg = 0;
    }
  if (args_info->client_arg)
    {
      free (args_info->client_arg); /* free previous argument */
      args_info->client_arg = 0;
    }
  if (args_info->build_menus_arg)
    {
      free (args_info->build_menus_arg); /* free previous argument */
      args_info->build_menus_arg = 0;
    }
  if (args_info->glivrc_arg)
    {
      free (args_info->glivrc_arg); /* free previous argument */
      args_info->glivrc_arg = 0;
    }
  if (args_info->slide_show_arg)
    {
      free (args_info->slide_show_arg); /* free previous argument */
      args_info->slide_show_arg = 0;
    }
  if (args_info->null_arg)
    {
      free (args_info->null_arg); /* free previous argument */
      args_info->null_arg = 0;
    }
  if (args_info->collection_arg)
    {
      free (args_info->collection_arg); /* free previous argument */
      args_info->collection_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "add-all",	2, NULL, 'a' },
        { "recursive",	2, NULL, 'R' },
        { "sort",	2, NULL, 'S' },
        { "shuffle",	2, NULL, 's' },
        { "force-load",	2, NULL, 'F' },
        { "client",	2, NULL, 'C' },
        { "build-menus",	2, NULL, 'e' },
        { "glivrc",	2, NULL, 'g' },
        { "slide-show",	2, NULL, 'w' },
        { "null",	2, NULL, '0' },
        { "collection",	2, NULL, 'o' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVa::R::S::s::F::C::e::g::w::0::o::", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'a':	/* Add all files in the directory.  */
          if (local_args_info.add_all_given)
            {
              fprintf (stderr, "%s: `--add-all' (`-a') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->add_all_given && ! override)
            continue;
          local_args_info.add_all_given = 1;
          args_info->add_all_given = 1;
          if (optarg)
            {
              if (args_info->add_all_arg)
                free (args_info->add_all_arg); /* free previous string */
              args_info->add_all_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'R':	/* Recursive directory traversal.  */
          if (local_args_info.recursive_given)
            {
              fprintf (stderr, "%s: `--recursive' (`-R') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->recursive_given && ! override)
            continue;
          local_args_info.recursive_given = 1;
          args_info->recursive_given = 1;
          if (optarg)
            {
              if (args_info->recursive_arg)
                free (args_info->recursive_arg); /* free previous string */
              args_info->recursive_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'S':	/* Show images in sorted order.  */
          if (local_args_info.sort_given)
            {
              fprintf (stderr, "%s: `--sort' (`-S') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->sort_given && ! override)
            continue;
          local_args_info.sort_given = 1;
          args_info->sort_given = 1;
          if (optarg)
            {
              if (args_info->sort_arg)
                free (args_info->sort_arg); /* free previous string */
              args_info->sort_arg = gengetopt_strdup (optarg);
            }
          break;

        case 's':	/* Show images in random order.  */
          if (local_args_info.shuffle_given)
            {
              fprintf (stderr, "%s: `--shuffle' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->shuffle_given && ! override)
            continue;
          local_args_info.shuffle_given = 1;
          args_info->shuffle_given = 1;
          if (optarg)
            {
              if (args_info->shuffle_arg)
                free (args_info->shuffle_arg); /* free previous string */
              args_info->shuffle_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'F':	/* Try to load every file.  */
          if (local_args_info.force_load_given)
            {
              fprintf (stderr, "%s: `--force-load' (`-F') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->force_load_given && ! override)
            continue;
          local_args_info.force_load_given = 1;
          args_info->force_load_given = 1;
          if (optarg)
            {
              if (args_info->force_load_arg)
                free (args_info->force_load_arg); /* free previous string */
              args_info->force_load_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'C':	/* Connect to an already running gliv.  */
          if (local_args_info.client_given)
            {
              fprintf (stderr, "%s: `--client' (`-C') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->client_given && ! override)
            continue;
          local_args_info.client_given = 1;
          args_info->client_given = 1;
          if (optarg)
            {
              if (args_info->client_arg)
                free (args_info->client_arg); /* free previous string */
              args_info->client_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'e':	/* No images menu at startup.  */
          if (local_args_info.build_menus_given)
            {
              fprintf (stderr, "%s: `--build-menus' (`-e') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->build_menus_given && ! override)
            continue;
          local_args_info.build_menus_given = 1;
          args_info->build_menus_given = 1;
          if (optarg)
            {
              if (args_info->build_menus_arg)
                free (args_info->build_menus_arg); /* free previous string */
              args_info->build_menus_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'g':	/* Use this configuration file or none.  */
          if (local_args_info.glivrc_given)
            {
              fprintf (stderr, "%s: `--glivrc' (`-g') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->glivrc_given && ! override)
            continue;
          local_args_info.glivrc_given = 1;
          args_info->glivrc_given = 1;
          if (optarg)
            {
              if (args_info->glivrc_arg)
                free (args_info->glivrc_arg); /* free previous string */
              args_info->glivrc_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'w':	/* Start the slide show immediately.  */
          if (local_args_info.slide_show_given)
            {
              fprintf (stderr, "%s: `--slide-show' (`-w') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->slide_show_given && ! override)
            continue;
          local_args_info.slide_show_given = 1;
          args_info->slide_show_given = 1;
          if (optarg)
            {
              if (args_info->slide_show_arg)
                free (args_info->slide_show_arg); /* free previous string */
              args_info->slide_show_arg = gengetopt_strdup (optarg);
            }
          break;

        case '0':	/* Read null-terminated filenames.  */
          if (local_args_info.null_given)
            {
              fprintf (stderr, "%s: `--null' (`-0') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->null_given && ! override)
            continue;
          local_args_info.null_given = 1;
          args_info->null_given = 1;
          if (optarg)
            {
              if (args_info->null_arg)
                free (args_info->null_arg); /* free previous string */
              args_info->null_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'o':	/* Output a collection.  */
          if (local_args_info.collection_given)
            {
              fprintf (stderr, "%s: `--collection' (`-o') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->collection_given && ! override)
            continue;
          local_args_info.collection_given = 1;
          args_info->collection_given = 1;
          if (optarg)
            {
              if (args_info->collection_arg)
                free (args_info->collection_arg); /* free previous string */
              args_info->collection_arg = gengetopt_strdup (optarg);
            }
          break;


        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_free (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  
  cmdline_parser_free (&local_args_info);
  return (EXIT_FAILURE);
}
