/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * See the COPYING file for license information.
 *
 * Guillaume Chazarain <booh@altern.org>
 */

/*************************************
 * The zoom frame with funky colors. *
 *************************************/

#include "gliv.h"

#include <gtkgl/gtkglarea.h>

extern rt_struct *rt;
extern GtkWidget *gl_widget;

/* Dimensions of the zoom frame. */
static gint zoom_frame_x, zoom_frame_y;
static gint zoom_frame_width, zoom_frame_height;

static gboolean zoom_frame_cleared = FALSE;

void draw_zoom_frame(gboolean draw)
{
    /*
     * We keep the coordinates of the previous
     * frame to erase it with a XOR.
     */
    static gint x = 0;
    static gint y = 0;
    static gint width = 0;
    static gint height = 0;
    static GdkGC *gc = NULL;
    GdkDrawable *d;

    d = gl_widget->window;
    if (gc == NULL) {
        gc = gdk_gc_new(d);
        gdk_gc_set_foreground(gc, &(gl_widget->style->white));
        gdk_gc_set_function(gc, GDK_XOR);
    }

    if (draw == TRUE) {
        gdk_gl_wait_gl();

        /* Erase the previous frame. */
        gdk_draw_rectangle(d, gc, FALSE, x, y, width, height);
    }

    /* Update saved coordinates. */
    x = zoom_frame_x;
    y = zoom_frame_y;
    width = zoom_frame_width;
    height = zoom_frame_height;

    /* Draw the new frame. */
    if (draw == TRUE) {
        gdk_draw_rectangle(d, gc, FALSE, x, y, width, height);

        zoom_frame_cleared = FALSE;

        gdk_gl_wait_gdk();
    }
}

void set_zoom_frame(gint x, gint y, gint width, gint height)
{
    if (width < 0) {
        zoom_frame_x = x + width;
        zoom_frame_width = -width;
    } else {
        zoom_frame_x = x;
        zoom_frame_width = width;
    }

    if (height < 0) {
        zoom_frame_y = y + height;
        zoom_frame_height = -height;
    } else {
        zoom_frame_y = y;
        zoom_frame_height = height;
    }
}

void clear_zoom_frame(void)
{
    if (zoom_frame_cleared == FALSE) {
        set_zoom_frame(-1, -1, 0, 0);
        draw_zoom_frame(FALSE);
        zoom_frame_cleared = TRUE;
    }
}

void zoom_frame(void)
{
    gdouble x, y, zoom;

    if (zoom_frame_width == 0 || zoom_frame_height == 0) {
        /* To avoid division by zero. */
        set_zoom_frame(-1, -1, 0, 0);
        draw_zoom_frame(TRUE);
        return;
    }

    zoom = MIN((gdouble) rt->wid_size->width / zoom_frame_width,
               (gdouble) rt->wid_size->height / zoom_frame_height);

    x = zoom_frame_x + zoom_frame_width / 2.0;
    y = zoom_frame_y + zoom_frame_height / 2.0;

    /* zoom. */
    matrix_zoom(zoom, x, y);

    /* center. */
    matrix_move(rt->wid_size->width / 2.0 - x, rt->wid_size->height / 2.0 - y);

    refresh(REFRESH_IMAGE | REFRESH_STATUS | APPEND_HISTORY);
}
