// $Id: menubar.cc,v 1.67 2003/11/03 07:39:00 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

// this file contains only the gnome-like creation of menus (via a list)
// see menu.cc for the normal case (called via CreatePointer_depending)

class Gtk_MenuBar : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_MenuBar();
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void CreatePointer_depending(const Widget &w,CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
private:
	void ApplyPreferences(Tag &t,const std::string &visibility) const;
//----------- below here the ancient gnome support is buried ---------
public:
	virtual void AdditionalMemberVars(const Widget &w,CxxFile &f,bool container=false) const;
	virtual void CreatePointer_Toplevel(const Widget &w,CxxFile &f) const;
	virtual void DestroyPointer_Toplevel(const Widget &w,CxxFile &f) const;
	virtual Subwidget IsSubwidget(const Widget &w,const Widget &ch) const
	{  return Configuration.gnome_support?is_Subwidget_all:no_Subwidgets; }
	virtual const std::string Instance(const Widget &parent,const Widget &w2,Subwidget sw=SW_Unknown) const;
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
private:
	bool can_map_it(const Widget &w,const Widget &sub) const;
	void recursively_fill_pointers(const Widget &w, CxxFile &f) const;
	void recursively_declare_pointers(const Widget &w, CxxFile &f) const;
	void recursively_build_menu(const Widget &w, CxxFile &f) const;
};

static Gtk_MenuBar Gtk_MenuBar;

const std::string Gtk_MenuBar::TypeName(const Widget &w) const
{  return GtkPrefix()+"MenuBar";
}

const std::string Gtk_MenuBar::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"menubar.h";
}

Gtk_MenuBar::Gtk_MenuBar()
{  Writer["GtkMenuBar"]=this;
}

void Gtk_MenuBar::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  
}

bool Gtk_MenuBar::can_map_it(const Widget &w,const Widget &sub) const
{  const std::string cl(sub.Class());
   if (cl=="Placeholder") return false;
   // we can't find MenuItems with submenus
   // but we can find Menus with submenus
   // 
   // forget about it! widget sometimes holds GtkMenus, sometimes GtkMenuItems
   // submenus vs. menus - I don't care to create them for now!
   if (/*cl!="GtkMenu" && */ sub.begin()!=sub.end()) return false;
   // empty menus are ignored (somewhat)
   if (cl=="GtkMenu" /* && sub.begin()==sub.end()*/) return false;
   return true;
}

void Gtk_MenuBar::CreatePointer_depending(const Widget &w,CxxFile &f) const
{  Parent::CreatePointer_depending(w,f);

   if (Configuration.gnome_support) 
   { 
     f.StartBlock();
     recursively_build_menu(w,f);
     // create tree
     f.Statement() << "gnome_app_fill_menu(GTK_MENU_SHELL(" 
		   << instance(w) << gtk_object_pointer() << "), " 
		   << Configuration.InstanceName(w.Name()) << "_uiinfo, "
		   << (Configuration.has_accelerators
		       ?"gmm_data->getAccelGroup()->"+gtk_object_pointer()+", "
		       :"NULL, ")
		   << "true, 0)";
     // fill widget pointers
     recursively_fill_pointers(w,f);
     f.EndBlock(); 
   } 
   else 
   {  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
         PushMenuElem(*i, f, Configuration.InstanceName(w.Name())+"->");
   }
}

void Gtk_MenuBar::ApplyPreferences(Tag &t, const std::string &visibility) const
{  Widget w(&t);
   for (Widget::iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {  Widget w2(*i);
	 if (!w2.hasProperty("cxx_visibility"))
	    w2.setProperty("cxx_visibility",visibility);
         if (w2.getBoolProperty(CXX_SEPERATE_CLASS))
	    w2.setProperty(CXX_SEPERATE_CLASS,"False");
         if (w2.begin()!=w2.end()) // recurse
	    ApplyPreferences(const_cast<Tag&>(w2.getTag()),visibility);
      }
   }
}

void Gtk_MenuBar::ApplyPreferences(Tag &t) const
{  Parent::ApplyPreferences(t);
   if (!Configuration.gnome_support) return;
// strictly this is old cruft which should go away!   
   if (Widget(t).hasProperty("cxx_visibility"))
      ApplyPreferences(t,Widget(t).getProperty("cxx_visibility","private"));
}

void Gtk_MenuBar::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   if (GTKMM1) WriteEnumPropertyNS(w,f,instance, "shadow_type");
}

//----------- below here the ancient gnome support is buried ---------

// this old gnome schema is sick - convert to the push_back
//   schema used by non gnome menu support
void Gtk_MenuBar::AdditionalMemberVars(const Widget &w,CxxFile &f,bool container) const
{  Parent::AdditionalMemberVars(w,f,container);
   if (!Configuration.gnome_support) return;
   // all are internal!
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
		i!=w.end_contained();++i)
   {  const Widget w2(*i);
      if (!can_map_it(w,w2)) continue;
      LookupWriter(w2).GHDeclaration(w2,f);
   }
}

void Gtk_MenuBar::DestroyPointer_Toplevel(const Widget &w,CxxFile &f) const
{  if (Configuration.gnome_support)
   {  for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
			i!=w.end_contained();++i)
         {  const Widget w2(*i);
            if (!can_map_it(w,w2)) continue;
            LookupWriter(w2).DestroyPointer(w2,f);
         } 
   }
   Parent::DestroyPointer_Toplevel(w,f);
}

static const std::string accelerators(const Widget &w)
{  if (!w.hasProperty("accelerator")) return "0, (GdkModifierType)0, ";
   std::string ret;
   for (Widget::const_iterator i=w.get_Accels();i!=w.end();++i)
      {  std::string modifiers=i->getGladeAttr("modifiers");
	 const std::string key=i->getGladeAttr("key");
	 const std::string signal=i->getGladeAttr("signal");
         
         if (modifiers.empty() || key.empty() || signal.empty())
         {  std::cerr << w.Name() << ": accel is missing param (" 
            	<< modifiers << ',' << key << ',' << signal << ")\n";
         }
         else if (signal=="activate")
         {  if (modifiers=="0") modifiers="(GdkModifierType)"+modifiers;
            ret+=key+", "+modifiers+", ";
            return ret;
         }
         else 
	 {  std::cerr << w.Name() << ": strange accelerator signal "<<signal << '\n';
         }
      }
   return "0, (GdkModifierType)0, ";
}

static const std::string pixmaps(const Widget &w)
{  if (w.hasProperty("stock_icon")) 
	return "GNOME_APP_PIXMAP_STOCK, "+w.getProperty("stock_icon")+", ";
   else return "GNOME_APP_PIXMAP_NONE, 0, ";
}

static const std::string tooltip(const Widget &w)
{  if (!w.hasProperty("tooltip")) return "0, ";
   return Configuration.static_Translatable(w.getProperty("tooltip"))+", ";
}

static CxxFile &standard_item(const Widget &w, CxxFile &f, const std::string &type
		, bool subinfo=false, bool output_label=true)
{  f << "{ "<< type << ", " 
     << (output_label?Configuration.static_Translatable(w.getProperty("label")):"0")
     << ", " << tooltip(w) << ' ';
   if (subinfo && type=="GNOME_APP_UI_RADIOITEMS")
      f << Configuration.InstanceName(w.Name()) << "_uiinfo, ";
   else if (subinfo && w.begin()!=w.end()) 
      f << Configuration.InstanceName((*w.begin()).Name()) << "_uiinfo, ";
   else f << "0, ";
   f << "0, 0, " // user_data, unused_data
     << pixmaps(w) << ' ' << accelerators(w) << "0 },";
   return f;
}

void Gtk_MenuBar::recursively_build_menu(const Widget &w, CxxFile &f) const
{  const std::string cl(w.Class());
   if (cl!="GtkMenu" && cl!="GtkMenuBar")
   {  std::cerr << "MenuBar::recursively_build_menu: strange widget type "<< cl
	<< '\n';
   }
   // first recurse
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {  const Widget w2(*i);
         if (w2.begin()!=w2.end())
         {  assert(++w2.begin()==w2.end());
            const Widget menu(*w2.begin());
            // assert(menu.begin()!=menu.end());
            // if (menu.begin()!=menu.end()) // we need even empty structures
               recursively_build_menu(menu,f);
         }
      }
   }
   // put radiomenuitems in a seperate list
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()=="GtkRadioMenuItem")
      {  const Widget w2(*i);
         const std::string radiogroup(w2.getProperty("group"));
         f.Declaration("static GnomeUIInfo ")
		<< Configuration.InstanceName(w2.Name()) << "_uiinfo[]";
         f.Assignment().StartBlock();
         standard_item(w2,f,"GNOME_APP_UI_ITEM").NewLine(false);
         Widget::const_iterator next(i);
         ++next;
         while (next!=w.end())
         {  Widget w3(*next);
            if (w3.Class()!="GtkRadioMenuItem" 
            	|| w3.getProperty("group")!=radiogroup)
               break;
            standard_item(w3,f,"GNOME_APP_UI_ITEM").NewLine(false);
            ++i;
            ++next;
         }
         f << "GNOMEUIINFO_END ";
         f.EndBlock();
      }
   }

   f.Declaration("static GnomeUIInfo " + Configuration.InstanceName(w.Name())
      	+ "_uiinfo[]").Assignment().StartBlock();
   // then build current level
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  const Widget w2(*i);
      const std::string cl(w2.Class());
      if (cl=="Placeholder")
      {  
      }
      else if (w2.begin()!=w2.end())
      {  const std::string stock_item(w2.getProperty("stock_item"));
         if (!!stock_item.empty())
         {  standard_item(w2,f,"GNOME_APP_UI_SUBTREE",true);
         }
         else 
            f << stock_item << '(' 
              << Configuration.InstanceName((*w2.begin()).Name()) << "_uiinfo),";
      }
      else if (cl=="GtkRadioMenuItem")
      {  standard_item(w2,f,"GNOME_APP_UI_RADIOITEMS",true,false);  
         // skip items of same group
         const std::string radiogroup(w2.getProperty("group"));
         Widget::const_iterator next(i);
         ++next;
         while (next!=w.end())
         {  Widget w3(*next);
            if (w3.Class()!="GtkRadioMenuItem" 
            	|| w3.getProperty("group")!=radiogroup)
               break;
            ++i;
            ++next;
         }
      }
      else if (cl=="GtkImageMenuItem")
      {  const std::string stock_item(w2.getProperty("stock_item"));
      	
         // TODO: GtkImageMenuItem has the notion of use_underline that
         // doesn't seem to be propagated to the GNOMEUIINFO macro.
         // Something's not to spec, but I don't know whom/where.
         if (stock_item=="GNOMEUIINFO_MENU_NEW_ITEM")
           f << stock_item << '('
             << Configuration.static_Translatable(w2.getProperty("label"))
             << ", " 
             << Configuration.static_Translatable(w2.getProperty("tooltip")) 
             << ", 0, 0), ";
         else if (!stock_item.empty()) 
           f << stock_item << "(0, 0), ";
         else standard_item(w2,f,"GNOME_APP_UI_ITEM");
      }
      else if (cl=="GtkPixmapMenuItem")
      {  const std::string stock_item(w2.getProperty("stock_item"));
      	
         if (stock_item=="GNOMEUIINFO_MENU_NEW_ITEM")
           f << stock_item << '('
             << Configuration.static_Translatable(w2.getProperty("label"))
             << ", " 
             << Configuration.static_Translatable(w2.getProperty("tooltip")) 
             << ", 0, 0), ";
         else if (!stock_item.empty()) 
           f << stock_item << "(0, 0), ";
         else standard_item(w2,f,"GNOME_APP_UI_ITEM");
      }
      else if (cl=="GtkCheckMenuItem" || cl=="GtkMenuItem")
      {  if (cl=="GtkMenuItem" && !w2.hasProperty("label"))
      	    f << "GNOMEUIINFO_SEPARATOR, ";
         else standard_item(w2,f,(cl=="GtkMenuItem"?"GNOME_APP_UI_ITEM":"GNOME_APP_UI_TOGGLEITEM"));
      }
      else if (cl=="GtkSeparatorMenuItem")
      {  f << "GNOMEUIINFO_SEPARATOR, ";
      }
      else std::cerr << "MenuBar::recursively_build_menu: strange sub-widget type "
      	<< cl << '\n';
      	
      f.NewLine(false);
   }
   f << "GNOMEUIINFO_END ";
   f.EndBlock();
}

void Gtk_MenuBar::recursively_fill_pointers(const Widget &w, CxxFile &f) const
{  const std::string cl(w.Class());
   if (cl!="GtkMenu" && cl!="GtkMenuBar")
   {  std::cerr << "MenuBar::recursively_fill_pointers: strange widget type "<< cl
	<< '\n';
   }
   // first recurse (no need to do it first, but it's consistent
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {  const Widget w2(*i);
         if (w2.begin()!=w2.end())
         {  assert(++w2.begin()==w2.end());
            const Widget menu(*w2.begin());
            // assert(menu.begin()!=menu.end());
            //if (menu.begin()!=menu.end())
               recursively_fill_pointers(menu,f);
         }
      }
   }
   // radiomenuitems are in a seperate list
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()=="GtkRadioMenuItem")
      {  const Widget w2(*i);
         const std::string radiogroup(w2.getProperty("group"));
         int index(0);
	 
	 f.Statement();
	 w2.markManaged();
	 f << Configuration.InstanceName(w2.Name()) << " = " << gtk_wrapper();
	 f << '(' << LookupWriter(w2.Class(),false).GtkCast(w2)
	 	<< '(' << Configuration.InstanceName(w2.Name())
	 	<< "_uiinfo[" << index << "].widget))";
         Widget::const_iterator next(i);
         ++next;
         while (next!=w.end())
         {  Widget w3(*next);
            if (w3.Class()!="GtkRadioMenuItem" 
            	|| w3.getProperty("group")!=radiogroup)
               break;
            ++index;
     	    f.Statement();
   	    f << Configuration.InstanceName(w3.Name())  << " = ";
   	    f << gtk_wrapper();
   	    w3.markManaged();
   	    f << '(' << LookupWriter(w3.Class(),false).GtkCast(w3)
	 	<< '(' << Configuration.InstanceName(w2.Name())
	 	<< "_uiinfo[" << index << "].widget))";
            ++i;
            ++next;
         }
      }
   }

   // then current level
   int index(0);
   std::string radiogroup="$some unused value$";
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  const Widget w2(*i);
      const std::string cl(w2.Class());
      // begin!=end dann Unterwidget
      if (cl=="Placeholder")
      {
      }
      else if (w2.begin()!=w2.end())
      {  // see can_map_it
      }
      else if (cl!="GtkRadioMenuItem")
      {  f.Statement();
	 f << Configuration.InstanceName(w2.Name())  << " = ";
   	 f << gtk_wrapper();
   	 w2.markManaged();
   	 f << '(' << LookupWriter(w2.Class(),false).GtkCast(w2)
	 	<< '(' << Configuration.InstanceName(w.Name())
	 	<< "_uiinfo[" << index << "].widget))";
	 ++index;
      }
      else // cl=="GtkRadioMenuItem"
      {  // count each group once
         if (radiogroup!=w2.getProperty("group"))
         {  ++index; radiogroup=w2.getProperty("group"); }
      }
   }
}

void Gtk_MenuBar::recursively_declare_pointers(const Widget &w, CxxFile &f) const
{  const std::string cl(w.Class());
   if (cl!="GtkMenu" && cl!="GtkMenuBar")
   {  std::cerr << "MenuBar::recursively_declare_pointers: strange widget type "<< cl
	<< '\n';
   }
   // first recurse (no need to do it first, but it's consistent
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {  const Widget w2(*i);
         if (w2.begin()!=w2.end())
         {  assert(++w2.begin()==w2.end());
            const Widget menu(*w2.begin());
            // assert(menu.begin()!=menu.end());
            // if (menu.begin()!=menu.end())
               recursively_declare_pointers(menu,f);
         }
      }
   }
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  const Widget w2(*i);
      if (w2.Class()!="Placeholder" 
      	 	&& w2.getProperty("cxx_visibility","private")=="private") 
      	 				// && CanBeManaged(w))
	 f.Declaration() << LookupWriter(w2).TypeName(w2) << " *"
	       << Configuration.InstanceName(w2.Name());
   }
}

void Gtk_MenuBar::CreatePointer_Toplevel(const Widget &w,CxxFile &f) const
{  Parent::CreatePointer_Toplevel(w,f);
   if (!Configuration.gnome_support) return;

   recursively_declare_pointers(w,f);
   
}

// gnome_app_fill_menu (GTK_MENU_SHELL (menubar1), menubar1_uiinfo,
//                      NULL, FALSE, 0);

const std::string Gtk_MenuBar::Instance(const Widget &parent,const Widget &w2, Subwidget sw) const
{  if (!Configuration.gnome_support) return Parent::Instance(parent,w2,sw);
   if (!can_map_it(parent,w2)) return "";
   return Configuration.InstanceName(w2.Name())+"->";
}

void Gtk_MenuBar::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   if (!Configuration.gnome_support) return;
   f.Include("libgnomeui/gnome-app.h");
   f.Include("libgnomeui/gnome-app-helper.h");
   f.Include("gdk/gdkkeysyms.h");
   f.Include("libgnomeui/gnome-stock.h");
   if (GTKMM1 && !Configuration.gettext_support) 
   {  // otherwise glibc 2.3 and gnome1 conflict
      f.Include("libintl.h");
      // otherwise we stumble over _N()
      f.Include("libgnome/libgnome.h");
   }
}

