// $Id: bonobo_dockitem.cc,v 1.5 2002/11/18 11:46:09 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Bonobo_DockItem : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Bonobo_DockItem();
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Bonobo_DockItem Bonobo_DockItem;

const std::string Bonobo_DockItem::TypeName(const Widget &w) const
{  return BonoboUIPrefix()+"DockItem";
}

const std::string Bonobo_DockItem::IncludeName(const Widget &w) const
{  if (Configuration.libbonobouimm_version >= Pkg_Version(1,3,0))
      return Configuration.BonoboUImmIncludePath()+"widgets/dockitem.h";
   return "bonobo/bonobo-dock-item.h";
}

Bonobo_DockItem::Bonobo_DockItem()
{  Writer["BonoboDockItem"]=this;
}

void Bonobo_DockItem::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
   const std::string name(w.getProperty("name","DockItem"));
   std::string options("0");
   if (w.getBoolProperty("exclusive")) options+="|BONOBO_DOCK_ITEM_BEH_EXCLUSIVE";
   if (w.getBoolProperty("never_floating")) options+="|BONOBO_DOCK_ITEM_BEH_NEVER_FLOATING";
   if (w.getBoolProperty("never_vertical")) options+="|BONOBO_DOCK_ITEM_BEH_NEVER_VERTICAL";
   if (w.getBoolProperty("never_horizontal")) options+="|BONOBO_DOCK_ITEM_BEH_NEVER_HORIZONTAL";
   if (w.getBoolProperty("locked")) options+="|BONOBO_DOCK_ITEM_BEH_LOCKED";
   if (options.size()>1) // strip leading '0|'
      options=std::string(options.begin()+2,options.end());
   // cast it (strange that this is necessary ...
   size_t pos;
   if (GNOME2) {
     // Convert to Gnome 2;
     while ((pos = options.find("BONOBO_DOCK_ITEM_BEH_")) != std::string::npos) {
       options.replace(pos, strlen("BONOBO_DOCK_ITEM_BEH_"),
		       "Gnome::Bonobo::DOCK_ITEM_BEH_");
     }
     if (options == "0") {
       options = "Gnome::Bonobo::DOCK_ITEM_BEH_NORMAL";
     }
   }
   else {
     options="BonoboDockItemBehavior("+options+")";
   }
   
   f << Configuration.CString_WithQuotes(name);
   f.FunctionArg(options);
}

bool Bonobo_DockItem::NeedExplicitCtor(const Widget &w) const
{  return true; }

void Bonobo_DockItem::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteEnumPropertyNS(w,f,instance, "shadow_type");
   // orientation
#warning orientation support missing
}
