// $Id: scrollbar.cc,v 1.21 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "range.hh"

class Gtk_ScrollBar : public Gtk_Range
{public:
	typedef Gtk_Range Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	// we use Parent's ConstructionArgs
	Gtk_ScrollBar();
};

static Gtk_ScrollBar Gtk_ScrollBar;

const std::string Gtk_ScrollBar::TypeName(const Widget &w) const
{  return GtkPrefix()+(w.Class()[3]=='H' ?"HScrollbar":"VScrollbar");
}

const std::string Gtk_ScrollBar::IncludeName(const Widget &w) const
{  return "gtk--/scrollbar.h";
}

Gtk_ScrollBar::Gtk_ScrollBar()
{  Writer["GtkHScrollBar"]=this; // old variant
   Writer["GtkVScrollBar"]=this; // old variant
   Writer["GtkHScrollbar"]=this;
   Writer["GtkVScrollbar"]=this;
}

