// $Id: range.cc,v 1.33 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "range.hh"

static Gtk_Range Gtk_Range(false);

#define COPY_TAG(name) adjustment.push_back(Tag(name,w.getString(name)))
const Widget Gtk_Range::get_adjustment(const Widget &w) const
{  static Tag adjustment("widget");
   std::string name(Configuration.InstanceName(w.Name())+"_adj");
   if (adjustment.getString("name")==name)
   {  return Widget(adjustment);
   }
   adjustment=Tag("widget");
   adjustment.push_back(Tag("class","GtkAdjustment"));
   adjustment.push_back(Tag("name",name));
   COPY_TAG("value");
   COPY_TAG("lower");
   COPY_TAG("upper");
   COPY_TAG("step");
   COPY_TAG("page");
   COPY_TAG("page_size");
   adjustment.push_back(Tag(CXX_IS_MANAGED,"true"));
   return Widget(adjustment);
}

const std::string Gtk_Range::TypeName(const Widget &w) const
{  return GtkPrefix()+"Range";
}

void Gtk_Range::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   Widget w2(get_adjustment(w));
   LookupWriter(w2).GCInclude(w2,f);
}

const std::string Gtk_Range::IncludeName(const Widget &w) const
{  return "gtk--/range.h";
}

Gtk_Range::Gtk_Range(bool base_class_init)
{  if (!base_class_init) Writer["GtkRange"]=this;
}

void Gtk_Range::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   std::string update_policy=w.getString("update_policy","GTK_UPDATE_ALWAYS");
   if (update_policy!="GTK_UPDATE_ALWAYS")
      f.Statement() << instance << "set_update_policy(" << update_policy << ')';
}

bool Gtk_Range::CantMemberConstruct(const Widget &w) const
{  return true; }

void Gtk_Range::CreatePointer(const Widget &w,CxxFile &f) const
{  Widget w2(get_adjustment(w));
   LookupWriter(w2).CreatePointer(w2,f); 
   Parent::CreatePointer(w,f);
}

void Gtk_Range::DestroyPointer(const Widget &w,CxxFile &f) const
{  Parent::DestroyPointer(w,f);
   Widget w2(get_adjustment(w));
   LookupWriter(w2).DestroyPointer(w2,f);
}

void Gtk_Range::ConstructionArgs(const Widget &w, CxxFile &f) const
{  Widget w2(get_adjustment(w));
   f.FunctionArg() << Reference(w2);
}

