// $Id: gnome_numberentry.cc,v 1.2 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

class Gnome_NumberEntry : public Gtk_HBox
{public:
	typedef Gtk_HBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_NumberEntry();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gnome_NumberEntry Gnome_NumberEntry;

const std::string Gnome_NumberEntry::TypeName(const Widget &w) const
{  return GnomePrefix()+"NumberEntry";
}

const std::string Gnome_NumberEntry::IncludeName(const Widget &w) const
{  return "gnome--/number-entry.h";
}

Gnome_NumberEntry::Gnome_NumberEntry()
{  Writer["GnomeNumberEntry"]=this;
}

void Gnome_NumberEntry::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   std::string title(w.getString("title"));
   f.Statement() << instance << "set_title(" << Configuration.Translatable(title) << ')';
}
