// $Id: gnome_entry.cc,v 1.2 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "combo.hh"

class Gnome_Entry : public Gtk_Combo
{public:
	typedef Gtk_Combo Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_Entry();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};

static Gnome_Entry Gnome_Entry;

const std::string Gnome_Entry::TypeName(const Widget &w) const
{  return GnomePrefix()+"Entry";
}

const std::string Gnome_Entry::IncludeName(const Widget &w) const
{  return "gnome--/entry.h";
}

Gnome_Entry::Gnome_Entry()
{  Writer["GnomeEntry"]=this;
}

void Gnome_Entry::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int max_saved(w.getInt("max_saved",0));
   f.Statement() << instance << "set_max_saved(" << max_saved << ')';
}
