// $Id: gnome_about.cc,v 1.5 2001/11/05 15:28:20 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome_dialog.hh"
#include "../strsep.h"

class Gnome_About : public Gnome_Dialog
{public:
	typedef Gnome_Dialog Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_About();
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{ return true; }
	void GCDefinition(const Widget &w, CxxFile &f) const;
};

static Gnome_About Gnome_About;

void Gnome_About::ConstructionArgs(const Widget &w, CxxFile &f) const
{  const std::string logo(w.getString("logo"));
   const std::string copyright(w.getString("copyright"));
   const std::string comments(w.getString("comments"));
   f.FunctionArg() << "PACKAGE, VERSION, "
   	<< Configuration.CString_WithQuotes(copyright) << ", "
   	<< Configuration.InstanceName(w.Name()) << "_authors, "
   	<< Configuration.Translatable(comments);
   if (logo.size()) 
      f.FunctionArg(Configuration.CString_WithQuotes(logo));
}

const std::string Gnome_About::TypeName(const Widget &w) const
{  return GnomePrefix()+"About";
}

const std::string Gnome_About::IncludeName(const Widget &w) const
{  return "gnome--/about.h";
}

Gnome_About::Gnome_About()
{  Writer["GnomeAbout"]=this;
}

void Gnome_About::GCDefinition(const Widget &w, CxxFile &f) const
{  Parent::GCDefinition(w,f);
   const std::string authors(w.getString("authors"));
   const std::string name(Configuration.InstanceName(w.Name()));
   char *buffer=(char*)alloca(authors.size()+1);
   memcpy(buffer,authors.c_str(),authors.size()+1);
   char *token,*stringp=buffer;
   f.Declaration() << "const char * const "<< name << "_authors[]";
   f.Assignment().StartBlock();
   if ((token=strsep(&stringp,"\n")))
   {  f << Configuration.CString_WithQuotes(token) << ", ";
   }
   while (stringp && (token=strsep(&stringp,"\n")))
   {  if (!stringp && !token[0]) // do not use the last empty string
         break;
      f << Configuration.CString_WithQuotes(token) << ", ";
   }
   f << "0";
   f.EndBlock();
}
