// $Id: box.cc,v 1.22 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

static Gtk_Box Gtk_Box(false);

const std::string Gtk_Box::TypeName(const Widget &w) const
{  return GtkPrefix()+(w.Class()[3]=='H' ?"HBox":"VBox");
}

const std::string Gtk_Box::IncludeName(const Widget &w) const
{  return "gtk--/box.h";
}

Gtk_Box::Gtk_Box(bool base_class_init)
{  if (!base_class_init)
   {  Writer["GtkHBox"]=this;
      Writer["GtkVBox"]=this;
   }
}

void Gtk_Box::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg() << PRINT_BOOL(w.getBool("homogeneous",homo_def));
   f.FunctionArg() << w.getInt("spacing",spac_def);
}

bool Gtk_Box::NeedExplicitCtor(const Widget &w) const
{  return w.getBool("homogeneous",homo_def)!=homo_def
	|| w.getInt("spacing",spac_def)!=spac_def; }


void Gtk_Box::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  const ChildParamList ch(w.get_Child_params());
   bool pack_end(ch.getString("pack","GTK_PACK_START")=="GTK_PACK_END");
   bool expand(ch.getBool("expand",true));
   bool fill(ch.getBool("fill",true));
   int padding(ch.getInt("padding",0));
   if (expand && fill && !padding)
      f.Statement() << instance 
        << (pack_end?"pack_end":"pack_start")
        << '(' << Reference(w) << ')';
   else
      f.Statement() << instance << (pack_end?"pack_end":"pack_start") 
        << '(' << Reference(w) << ", " << PRINT_BOOL(expand) 
        << ", " << PRINT_BOOL(fill) << ", " << padding << ')';
}

void Gtk_Box::Configure(const Widget &w,CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   if (w.hasTag("child_name")) // our ctor was never called
   {  bool homogeneous(w.getBool("homogeneous",homo_def));
      if (homogeneous!=homo_def) 
      	 f.Statement() << instance << "set_homogeneous(" << PRINT_BOOL(homogeneous) << ')';
      int spacing(w.getInt("spacing",spac_def));
      if (spacing!=spac_def) 
         f.Statement() << instance << "set_spacing(" << spacing << ')';
   }
}
