// $Id: adjustment.cc,v 1.15 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "adjustment.hh"

static Gtk_Adjustment Gtk_Adjustment;
//static Gtk_Adjustment hGtk_Adjustment('h');
//static Gtk_Adjustment vGtk_Adjustment('v');

const std::string Gtk_Adjustment::TypeName(const Widget &w) const
{  return GtkPrefix()+"Adjustment";
}

const std::string Gtk_Adjustment::IncludeName(const Widget &w) const
{  return "gtk--/adjustment.h";
}

Gtk_Adjustment::Gtk_Adjustment()
{  Writer["GtkAdjustment"]=this;
}

void Gtk_Adjustment::ConstructionArgs(const Widget &w, CxxFile &f) const
{  float value(w.getFloat("value",0));
   float lower(w.getFloat("lower",0));
   float upper(w.getFloat("upper",100));
   float step(w.getFloat("step",1));
   float page(w.getFloat("page",10));
   float page_size(w.getFloat("page_size",10));
      
   f.FunctionArg() << value;
   f.FunctionArg() << lower;
   f.FunctionArg() << upper;
   f.FunctionArg() << step;
   f.FunctionArg() << page;
   f.FunctionArg() << page_size;
}
