// $Id: Class.cc,v 1.7 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "WriterBase.hh"

// XXX: Compound and Class are the same???

class Class : public WriterBase // or Gtk_Widget etc.
{public:
	typedef WriterBase Parent;
	virtual const std::string TypeName(const Widget &w) const
	{  return Configuration.TypeName(w.Name());
	}
	virtual const std::string IncludeName(const Widget &w) const
	{  return Configuration.FileName(w.Name(),File_FOO_HH,
	                                File_NOREPLACE|File_NODIR);
	}
	virtual void GHInclude(const Widget &w, CxxFile &f) const;
	Class()
	{  Writer["Class"]=this;
	}
// XXX: ctor args?
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return Configuration.has_accelerators; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
	virtual bool CantMemberConstruct(const Widget &) const
	{  return Configuration.has_accelerators; }
	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const
	{  std::cerr << "you reached a bug (InternalInstance of Class)\n"; assert(false); }
};

static Class Class;

void Class::GHInclude(const Widget &w, CxxFile &f) const
{  if (w.getBool(CXX_SEPERATE_FILE,false))
      f.Include(IncludeName(w),true); // XXX: we need not include it
       			// here, perhaps only in gc to speed up compilation
   else
      f.Declaration().Class(TypeName(w)).EndLine();
}

void Class::ConstructionArgs(Widget const &w, CxxFile &f) const
{  f.FunctionArg(); 
   if (Configuration.has_accelerators)
   {  f << "_data";
   }
}

