// $Id: Cxx.hh,v 1.24 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <Tag.hh>
#include <MakeFile.hh>
#include <ShellFile.hh>
#include <Naming.hh>
#include "Cxx_Fileset.hh"

class Cxx : Naming
{  	CxxFile main;
	MakeFile makefile_am,configure_in,makefile;
	ShellFile autogen,potfiles;
	CxxFile acconfig;
	
	Tag *top;
	Cxx_Fileset *current_set;

	friend void Cxx_Fileset::WriteFiles(bool);
private:
	// changes Tag tree
	void ApplyPreferences(Tag &t,int level=0);
	void WriteTags(Tag &t);

	void CreateSupportFiles();
	void CreateSupportFiles_1_2(CxxFile &support_h,CxxFile &support_c);
	
	// write a first header
	void WriteHeader(CxxFile &f,File_type tp); // main, support
//	void WriteHeader(MakeFile &f,File_type tp);
	void WriteHeader(SystemFile &f,File_type tp);
	
	void WriteFooter(CxxFile &f,File_type tp); // main
//	void WriteFooter(MakeFile &f,File_type tp);
	void WriteFooter(SystemFile &f,File_type tp);
	
//	void WriteCreation(CxxFile &f,File_type tp);
//	void WriteCreation(MakeFile &f,File_type tp);

public:
	Cxx(Tag *top);
	void WriteTags();

	// convenience wrapper Function	
	static const std::string FileNameByType(const File_type &tp,int flags=File_NOREPLACE);
	static void WriteCreation(SystemFile &f,File_type tp);
};
