// $Id: Configuration.hh,v 1.23 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CONFIGURATION_HH
#define CONFIGURATION_HH
#include <config.h>
#include "Naming.hh"

// Be careful, glibc-2.1 defines major and minor

struct Gtkmm_Version
{  int mymajor;
   int myminor;
   int mymicro;
   
   Gtkmm_Version() : mymajor(0), myminor(0), mymicro(0) {}
   Gtkmm_Version(int j,int n,int c) : mymajor(j), myminor(n), mymicro(c) {}
   bool operator==(const Gtkmm_Version &b) const 
   {  return mymajor==b.mymajor && myminor==b.myminor && mymicro==b.mymicro; }
   bool operator<(const Gtkmm_Version &b) const 
   {  if (mymajor!=b.mymajor) return mymajor<b.mymajor;
      if (myminor!=b.myminor) return myminor<b.myminor;
      return mymicro<b.mymicro;
   }
   bool operator>=(const Gtkmm_Version &b) const 
   {  return !(*this<b); }
   bool operator!=(const Gtkmm_Version &b) const 
   {  return !(*this==b); }
};

typedef Gtkmm_Version Gtk_Version;
typedef Gtkmm_Version Gnomemm_Version;

struct Configuration : public Naming
{  std::string destination_directory;
   std::string source_directory;
   std::string main_filename;
   std::string in_filename;
   std::string pixmap_dir;
   std::string commandline;
   std::string pixmap_dir_relative_to_src;
   bool debug:1;
   bool sample_code:1;
   bool bare_bones:1;
   bool no_autoconf:1;
   bool gtk_ostream:1;
   bool lookup_table:1;
   bool gnome_support:1;
   bool gettext_support:1;
   bool use_libglade:1;
   bool has_accelerators:1;
   bool widget_names:1;
   bool optionmenu_strings:1;
   bool optionmenu_create_enum:1;
   bool do_case_conversion:1;
   bool uppercase_enums:1;
   bool mixedcase_defines:1;
   // compatibility
//   bool all_pointer:1;
   bool lookup_table_compat:1;
   Gtk_Version gtk_version;
   Gtkmm_Version gtkmm_version;
   Gnomemm_Version gnomemm_version;
   std::string template_postfix;
   std::string source_suffix, header_suffix;
   
   Configuration()
   : debug(false), sample_code(false), 
     bare_bones(false), 
     no_autoconf(false), gtk_ostream(false),
     lookup_table(false), gnome_support(false),
     gettext_support(false), use_libglade(false),
     has_accelerators(false), widget_names(false),
     optionmenu_strings(false), optionmenu_create_enum(true),
     do_case_conversion(false), uppercase_enums(false),
     mixedcase_defines(false),
     lookup_table_compat(false),
     gtk_version(GTK_MAJOR,GTK_MINOR,GTK_MICRO),
     gtkmm_version(GTKMM_MAJOR,GTKMM_MINOR,GTKMM_MICRO),
#ifdef GNOMEMM_MAJOR     
     gnomemm_version(GNOMEMM_MAJOR,GNOMEMM_MINOR,GNOMEMM_MICRO),
#endif     
     // had been "_glade"
     template_postfix("_new"),
     source_suffix(".cc"), header_suffix(".hh")
   {}
};

extern struct Configuration Configuration;
#endif
