#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <dirent.h>
#include <errno.h>

#include <gtk/gtk.h>

#include "../config.h"

#include "defines.h"
#include "debconf.h"
#include "gtk_gui.h"
#include "files.h"

#define INFODIR "/var/lib/dpkg/info"
#define CONFIGEXT ".config"

extern gint errno;
extern GtkWidget *main_window;

/*
  sorts the package names by name
*/
int
sort_configs (gconstpointer a, gconstpointer b)
{
  gchar *as = (gchar*)a;
  gchar *bs = (gchar*)b;
  gint i;

  /*
    only compares what is different
  */
  for (i = 0 ; as[i] == bs[i] ; i++);

  if (as[i] > bs[i])
    return 1;
  else
    return 0;

  return 0; // not reached
}

/*
  This lists the *.config files in /var/lib/dpkg/info
  and list them in the main combo box as packages wich
  can be configured
*/
int
get_options (GtkWidget *combo)
{
  DIR *dir;
  struct dirent *dent;
  gchar *point;
  gint i;

  GList *cflist = NULL;

  if ((dir = opendir (INFODIR)) == NULL)
    {
      perror(_("Opening "INFODIR));
      return -1;
    }

  for (i = 3 ; (dent = readdir (dir)) ; i++)
    {
      if ((point = strrchr (dent->d_name, '.')) == NULL)
	continue;
      
      if (!strcmp (point, CONFIGEXT))
	{
	  bzero (point, strlen(point));
	  cflist = g_list_insert_sorted (cflist,
					 g_strdup (dent->d_name),
					 sort_configs);
	  gtk_combo_set_popdown_strings (GTK_COMBO(combo),
					 cflist);
	}
    }

  closedir(dir);

  return 0;
}
