#include <stdio.h>
#include <gtk/gtk.h>
#include <gconf/gconf.h>

#include "../config.h"

#include "defines.h"

#include "files.h"
#include "gtk_gui.h"
#include "splash.h"

GtkWidget *main_window;

int
main (int argc, char **argv)
{
  GtkWidget *splashwin;
  GError *err;

  /* Gettext stuff */
  setlocale (LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);
  gtk_set_locale();

  gtk_init (&argc, &argv);

  if (!gconf_init (argc, argv, &err))
    {
      fprintf (stderr, _("Error: %s"), err->message);
      g_error_free (err);
    }
 
  /*
    shows a splash screen
  */
  splashwin = gk_splash ();
  gtk_widget_show_now (splashwin);

  while (gtk_events_pending())
    gtk_main_iteration(); 
  
  /*
    creates main window
    check the gtk signal bindings done in this
    function to know what functions are called
    to detect the packages that are configurable
    and sort them
  */
  main_window = create_main_window();

  /* destroy splash and show main */
  gtk_widget_destroy (splashwin);
  gtk_widget_show (main_window);

  /* let's use the program */
  gtk_main();
  return 0;
}

