#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "../config.h"

#include "defines.h"
#include "gtk_gui.h"
#include "config.h"

#define GCONF_DIR "/apps/gkdebconf"

/*
  still unused, will help on remembering the last
  frontend used
*/
int
write_config (gchar *option, gchar *data)
{
  GConfClient *confclient = NULL;
  GError *err = NULL;
  gchar *confkey = NULL;

  confclient = gconf_client_get_default ();
  confkey = g_strdup_printf ("%s/%s", GCONF_DIR, option);
  gconf_client_set_string (confclient, confkey, data, &err);
  if (err != NULL)
    {
      fprintf (stderr, "option: %s\ndata: %s\nresult: %s\n",
	       option, data, err->message);
      g_error_free (err);
      return 1;
    }

  g_free (confkey);
  return 0;
}
  

char*
read_config (gchar *option)
{
  GConfClient *confclient = NULL;
  GError *err = NULL;
  gchar *confkey = NULL;
  gchar *data = NULL;

  confclient = gconf_client_get_default ();
  confkey = g_strdup_printf ("%s/%s", GCONF_DIR, option);
  data = gconf_client_get_string (confclient, confkey, &err);
  if (data == NULL)
    {
      if (err != NULL)
	{
	  fprintf (stderr, _("Error getting data: %s"),
		   err->message);
	  g_error_free (err);
	}
      return "none";
    }

  g_free (confkey);
  return data;
}
