/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-plugin-manager.h"

#include <gmodule.h>

#include <string.h>


#define ENV_VAR_NAME "G_INSPECTOR_PLUGINS"
#define PLUGIN_MODULE_ENTRY_POINT_FUNC_NAME "plugin_module_entry_point"


static void load_module (gchar *filename);


static GList *plugin_module_list = NULL;



void
g_inspector_plugin_register_module (const GInspectorPluginModuleInfo *plugin_module_info)
{
  g_return_if_fail (plugin_module_info != NULL);
  g_return_if_fail (plugin_module_info->name != NULL);

  plugin_module_list = g_list_append (plugin_module_list,
				      (gpointer)plugin_module_info);
}

GList*
g_inspector_plugin_get_module_list (void)
{
  return plugin_module_list;
}

GInspectorPluginModuleInfo*
g_inspector_plugin_find_module (const gchar *name)
{
  GInspectorPluginModuleInfo *tmp_plugin_module_info;
  GInspectorPluginModuleInfo *plugin_module_info;
  GList *tmp;


  g_return_val_if_fail (name != NULL, NULL);


  plugin_module_info = NULL;


  tmp = plugin_module_list;
  while (tmp != NULL)
    {
      tmp_plugin_module_info = tmp->data;
      tmp = g_list_next (tmp);

      if (strcmp (tmp_plugin_module_info->name, name) == 0)
	{
	  plugin_module_info = tmp_plugin_module_info;
	  break;
	}
    }


  return plugin_module_info;
}


void
g_inspector_plugin_load_modules (void)
{
  const gchar *env_string;


  env_string = g_getenv (ENV_VAR_NAME);

  if (env_string != NULL)
    {
      if (g_module_supported() != TRUE)
	{
	  g_print ("g_module_supported() != TRUE, ignoring %s", ENV_VAR_NAME);
	}
      else
	{
	  gchar **module_filenames;
	  gchar *module_filename;
	  int i;

	  module_filenames = g_strsplit (env_string, G_SEARCHPATH_SEPARATOR_S, -1);

	  for (i = 0; module_filenames[i] != NULL; ++i)
	    {
	      module_filename = module_filenames[i];

	      load_module (module_filename);
	    }

	  if (module_filenames != NULL)
	    {
	      g_strfreev (module_filenames);
	    }
	}
    }
}

static void
load_module (gchar *filename)
{
  GModule *gmodule;


  gmodule = g_module_open (filename, G_MODULE_BIND_LAZY);

  if (gmodule == NULL)
    {
      g_print ("Can't open plugin module: %s: %s\n",
	       filename, g_module_error());
    }
  else
    {
      gboolean r;
      GInspectorPluginModuleEntryPoint entry_point;

      r = g_module_symbol (gmodule,
			   PLUGIN_MODULE_ENTRY_POINT_FUNC_NAME,
			   (gpointer *)&entry_point);

      if (r == FALSE)
	{
	  g_print ("Can't retrieve symbol '%s': %s\n",
		   PLUGIN_MODULE_ENTRY_POINT_FUNC_NAME,
		   filename);
	}
      else
	{
	  (* entry_point) ();
	}
    }
}

void
g_inspector_plugin_init_modules (void)
{
  GInspectorPluginModuleInfo *plugin_module_info;
  GList *tmp;

  tmp = plugin_module_list;
  while (tmp != NULL)
    {
      plugin_module_info = tmp->data;
      tmp = g_list_next (tmp);
	
      g_print ("plugin: %s\n", plugin_module_info->name);

      if (plugin_module_info->init != NULL)
	{
	  (* plugin_module_info->init) ();
	}
    }
}

void
g_inspector_plugin_activate_modules (void)
{
  GInspectorPluginModuleInfo *plugin_module_info;
  GList *tmp;

  tmp = plugin_module_list;
  while (tmp != NULL)
    {
      plugin_module_info = tmp->data;
      tmp = g_list_next (tmp);
	
      if (plugin_module_info->activate != NULL)
	{
	  (* plugin_module_info->activate) ();
	}
    }
}

void
g_inspector_plugin_deactivate_modules (void)
{
  GInspectorPluginModuleInfo *plugin_module_info;
  GList *tmp;

  tmp = plugin_module_list;
  while (tmp != NULL)
    {
      plugin_module_info = tmp->data;
      tmp = g_list_next (tmp);
	
      if (plugin_module_info->deactivate != NULL)
	{
	  (* plugin_module_info->deactivate) ();
	}
    }
}
