/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __G_INSPECTOR_ELEMENT_HOLDER_H__
#define __G_INSPECTOR_ELEMENT_HOLDER_H__


#include <glib-object.h>

#include "ginspector-element.h"


G_BEGIN_DECLS



#define G_TYPE_INSPECTOR_ELEMENT_HOLDER            (g_inspector_element_holder_get_type ())
#define G_INSPECTOR_ELEMENT_HOLDER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_INSPECTOR_ELEMENT_HOLDER, GInspectorElementHolder))
#define G_INSPECTOR_ELEMENT_HOLDER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), G_TYPE_INSPECTOR_ELEMENT_HOLDER, GInspectorElementHolderClass))
#define G_IS_INSPECTOR_ELEMENT_HOLDER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_INSPECTOR_ELEMENT_HOLDER))
#define G_IS_INSPECTOR_ELEMENT_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G_TYPE_INSPECTOR_ELEMENT_HOLDER))
#define G_INSPECTOR_ELEMENT_HOLDER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), G_TYPE_INSPECTOR_ELEMENT_HOLDER, GInspectorElementHolderClass))


typedef struct _GInspectorElementHolder        GInspectorElementHolder;
typedef struct _GInspectorElementHolderClass   GInspectorElementHolderClass;

struct _GInspectorElementHolder
{
  GObject object;

  GInspectorElementType element_type;
  gpointer              element;
};

struct _GInspectorElementHolderClass
{
  GObjectClass parent_class;

  void (* changed) (GInspectorElementHolder *element_holder);
};


GType g_inspector_element_holder_get_type (void) G_GNUC_CONST;

GInspectorElementHolder* g_inspector_element_holder_new (void);
void                     g_inspector_element_holder_set
						(GInspectorElementHolder *element_holder,
						 GInspectorElementType    element_type,
						 gpointer                 element);
void                     g_inspector_element_holder_unset
						(GInspectorElementHolder *element_holder);
GInspectorElementType    g_inspector_element_holder_get_element_type
						(GInspectorElementHolder *element_holder);
gpointer                 g_inspector_element_holder_get_element
						(GInspectorElementHolder *element_holder);

void                     g_inspector_element_holder_set_gtypeinstance
						(GInspectorElementHolder *element_holder,
						 GTypeInstance           *instance);
void                     g_inspector_element_holder_set_gobject
						(GInspectorElementHolder *element_holder,
						 GObject                 *gobject);
void                     g_inspector_element_holder_set_gtype
						(GInspectorElementHolder *element_holder,
						 GType                    gtype);



G_END_DECLS


#endif /* __G_INSPECTOR_ELEMENT_HOLDER_H__ */
