/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-tag.h"


static const gchar *inspector_tag_string = "g-inspector-tag";
static GQuark       inspector_tag_quark  = 0;


void
g_inspector_tag_to_object (GObject *object)
{
  g_return_if_fail (object != NULL);
  g_return_if_fail (G_IS_OBJECT (object));


  if (inspector_tag_quark == 0)
    {
      inspector_tag_quark
	= g_quark_from_static_string (inspector_tag_string);
    }

  g_object_set_qdata (G_OBJECT (object),
		      inspector_tag_quark,
		      (gpointer)"G-Inspector tag");
}

gboolean
g_inspector_tag_check_object (GObject *object)
{
  gpointer data;
  gboolean tagged;

  g_return_val_if_fail (object != NULL, FALSE);
  g_return_val_if_fail (G_IS_OBJECT (object), FALSE);


  if (inspector_tag_quark == 0)
    {
      inspector_tag_quark
	= g_quark_from_static_string (inspector_tag_string);
    }

  data = g_object_get_qdata (G_OBJECT (object),
			     inspector_tag_quark);

  if (data != NULL)
    {
      tagged = TRUE;
    }
  else
    {
      tagged = FALSE;
    }


  return tagged;
}
