/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "glrr-glib.h"
#include "glrr-gtk.h"

#include "config.h"



static void builtin_module_init (void);

static gpointer create_panel_allocation  (gpointer data,
					  gpointer func_data,
					  gpointer invoke_data);
static gpointer create_panel_requisition (gpointer data,
					  gpointer func_data,
					  gpointer invoke_data);
#ifdef HAVE__GTK_WIDGET_GET_AUX_INFO
static gpointer create_panel_aux_info    (gpointer data,
					  gpointer func_data,
					  gpointer invoke_data);
#endif



void
g_inspector_builtin_register_module_panel_widget_instance (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-widget-instance";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-widget-instance-allocation",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_WIDGET,
				  create_panel_allocation,
				  NULL);

  g_inspector_register_procedure ("create-panel-widget-instance-requisition",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_WIDGET,
				  create_panel_requisition,
				  NULL);


#ifdef HAVE__GTK_WIDGET_GET_AUX_INFO
  g_inspector_register_procedure ("create-panel-widget-instance-aux-info",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_WIDGET,
				  create_panel_aux_info,
				  NULL);
#endif
}


/*
 *
 */

static void
size_allocate (GtkWidget     *widget,
	       GtkAllocation *allocation,
	       gpointer       user_data)
{
  GInspectorPanel *panel;

  panel = G_INSPECTOR_PANEL (user_data);

  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));
}

static void
panel_allocation_update (GInspectorPanel *panel,
			 gpointer         user_data)
{
  GtkWidget *widget;

  widget = GTK_WIDGET (panel->element);


#define SET(n,f,a) \
    G_STMT_START { \
      gtk_label_set_text_printf								    \
	(GTK_LABEL (gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), (n))),    \
	 (f), (a));									    \
    } G_STMT_END

  SET ("label-x-value",      "%d", widget->allocation.x);
  SET ("label-y-value",      "%d", widget->allocation.y);
  SET ("label-width-value",  "%d", widget->allocation.width);
  SET ("label-height-value", "%d", widget->allocation.height);

#undef SET
}

static gpointer
create_panel_allocation (gpointer data,
			 gpointer func_data,
			 gpointer invoke_data)
{
  GtkWidget *widget;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;


  widget = GTK_WIDGET (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);

    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE;
    G_INSPECTOR_PANEL (panel)->element = widget;

    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Allocation");
    gtk_container_add (GTK_CONTAINER (top), frame);
  }

  {
    GClosure *closure;

    closure = g_cclosure_new_object (G_CALLBACK (size_allocate),
				     G_OBJECT (panel));

    g_signal_connect_closure (widget,
			      "size_allocate",
			      closure,
			      FALSE);
  }

  {
    g_signal_connect (panel,
		      "update",
		      G_CALLBACK (panel_allocation_update),
		      NULL);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }

  {
    GtkWidget *table;

    GList *label_list;
    GtkWidget *label;
    gint n;
    gint i;

    label_list
      = g_list_new (gtk_label_new ("X:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-x-value", NULL),

		    gtk_label_new ("Y:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-y-value", NULL),

		    gtk_label_new ("Width:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-width-value", NULL),

		    gtk_label_new ("Height:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-height-value", NULL),

		    NULL);

    n = g_list_length (label_list);


    table = gtk_table_new (2, n/2, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);


    for (i = 0; i < n; ++i)
      {
	label = g_list_nth_data (label_list, i);

	{
	  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	}

	{
	  gint left_attach;
	  gint top_attach;

	  left_attach = (i % 2);
	  top_attach  = (i / 2);

	  gtk_table_attach (GTK_TABLE (table),
			    label,
			    (left_attach + 0),
			    (left_attach + 1),
			    (top_attach + 0),
			    (top_attach + 1),
			    GTK_FILL, GTK_FILL,
			    4, 0);
	}
      }

    if (label_list != NULL)
      {
	g_list_free (label_list);
      }
  }

  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}


/*
 *
 */

static void
size_request (GtkWidget      *widget,
	      GtkRequisition *requisition,
	      gpointer        user_data)
{
  GInspectorPanel *panel;

  panel = G_INSPECTOR_PANEL (user_data);

  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));
}

static void
panel_requisition_update (GInspectorPanel *panel,
			  gpointer         user_data)
{
  GtkWidget *widget;

  widget = GTK_WIDGET (panel->element);


#define SET(n,f,a) \
    G_STMT_START { \
      gtk_label_set_text_printf								    \
	(GTK_LABEL (gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), (n))),    \
	 (f), (a));									    \
    } G_STMT_END

  SET ("label-width-value",  "%d", widget->requisition.width);
  SET ("label-height-value", "%d", widget->requisition.height);

#undef SET
}

static gpointer
create_panel_requisition (gpointer data,
			  gpointer func_data,
			  gpointer invoke_data)
{
  GtkWidget *widget;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;


  widget = GTK_WIDGET (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);

    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE;
    G_INSPECTOR_PANEL (panel)->element = widget;

    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Requisition");
    gtk_container_add (GTK_CONTAINER (top), frame);
  }

  {
    GClosure *closure;

    closure = g_cclosure_new_object (G_CALLBACK (size_request),
				     G_OBJECT (panel));

    g_signal_connect_closure (widget,
			      "size_request",
			      closure,
			      FALSE);
  }

  {
    g_signal_connect (panel,
		      "update",
		      G_CALLBACK (panel_requisition_update),
		      NULL);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }

  {
    GtkWidget *table;

    GList *label_list;
    GtkWidget *label;
    gint n;
    gint i;

    label_list
      = g_list_new (gtk_label_new ("Width:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-width-value", NULL),

		    gtk_label_new ("Height:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-height-value", NULL),

		    NULL);

    n = g_list_length (label_list);


    table = gtk_table_new (n/2, 2, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);


    for (i = 0; i < n; ++i)
      {
	label = g_list_nth_data (label_list, i);

	{
	  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	}

	{
	  gint left_attach;
	  gint top_attach;

	  left_attach = (i % 2);
	  top_attach  = (i / 2);

	  gtk_table_attach (GTK_TABLE (table),
			    label,
			    (left_attach + 0),
			    (left_attach + 1),
			    (top_attach + 0),
			    (top_attach + 1),
			    GTK_FILL, GTK_FILL,
			    4, 0);
	}
      }
  }

  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}

/*
 *
 */

#ifdef HAVE__GTK_WIDGET_GET_AUX_INFO

static void
panel_aux_info_update (GInspectorPanel *panel,
		       gpointer         user_data)
{
  GtkWidget *widget;
  GtkWidgetAuxInfo *aux_info;

  widget = GTK_WIDGET (panel->element);

  aux_info = _gtk_widget_get_aux_info (widget, FALSE);


#define SET(n,f,a) \
    G_STMT_START { 									    \
      if (aux_info != NULL) {								    \
	gtk_label_set_text_printf							    \
	  (GTK_LABEL (gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), (n))),  \
	   (f), (a));									    \
      } else {										    \
	gtk_label_set_text								    \
	  (GTK_LABEL (gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), (n))),  \
	   NULL);									    \
      }											    \
    } G_STMT_END



  SET ("label-x",      "%s", "X:");
  SET ("label-y",      "%s", "Y:");
  SET ("label-width",  "%s", "Width:");
  SET ("label-height", "%s", "Height:");
  SET ("label-xset",   "%s", "x_set:");
  SET ("label-yset",   "%s", "y_set:");

  SET ("label-x-value",      "%d", aux_info->x);
  SET ("label-y-value",      "%d", aux_info->y);
  SET ("label-width-value",  "%d", aux_info->width);
  SET ("label-height-value", "%d", aux_info->height);
  SET ("label-xset-value",   "%s", (aux_info->x_set ? "TRUE" : "FALSE"));
  SET ("label-yset-value",   "%s", (aux_info->y_set ? "TRUE" : "FALSE"));

#undef SET
}


static gpointer
create_panel_aux_info (gpointer data,
		       gpointer func_data,
		       gpointer invoke_data)
{
  GtkWidget *widget;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;


  widget = GTK_WIDGET (data);

  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);

    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE;
    G_INSPECTOR_PANEL (panel)->element = widget;

    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Aux Info");
    gtk_container_add (GTK_CONTAINER (top), frame);
  }

  {
    g_signal_connect (panel,
		      "update",
		      G_CALLBACK (panel_aux_info_update),
		      NULL);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }

  {
    GtkWidget *table;

    GList *label_list;
    GtkWidget *label;
    gint n;
    gint i;

    label_list
      = g_list_new (g_object_new (GTK_TYPE_LABEL, "name", "label-x", NULL),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-x-value", NULL),

		    g_object_new (GTK_TYPE_LABEL, "name", "label-y", NULL),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-y-value", NULL),

		    g_object_new (GTK_TYPE_LABEL, "name", "label-width", NULL),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-width-value", NULL),

		    g_object_new (GTK_TYPE_LABEL, "name", "label-height", NULL),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-height-value", NULL),

		    g_object_new (GTK_TYPE_LABEL, "name", "label-xset", NULL),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-xset-value", NULL),
		    
		    g_object_new (GTK_TYPE_LABEL, "name", "label-yset", NULL),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-yset-value", NULL),

		    NULL);

      n = g_list_length (label_list);


      table = gtk_table_new (2, n/2, FALSE);
      gtk_container_add (GTK_CONTAINER (frame), table);
      gtk_container_set_border_width (GTK_CONTAINER (table), 4);


      for (i = 0; i < n; ++i)
	{
	  label = g_list_nth_data (label_list, i);

	  {
	    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	  }

	  {
	    gint left_attach;
	    gint top_attach;

	    left_attach = (i % 2);
	    top_attach  = (i / 2);

	    gtk_table_attach (GTK_TABLE (table),
			      label,
			      (left_attach + 0),
			      (left_attach + 1),
			      (top_attach + 0),
			      (top_attach + 1),
			      GTK_FILL, GTK_FILL,
			      4, 0);
	  }
	}
    }

  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}
#endif
