/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "glrr-gobject.h"

#include <string.h>



static void builtin_module_init (void);

static gpointer invoke_default_procedure_for_gtypeinstance (gpointer data,
							    gpointer func_data,
							    gpointer invoke_data);
static gpointer invoke_default_procedure_for_gtypeclass    (gpointer data,
							    gpointer func_data,
							    gpointer invoke_data);
static gpointer invoke_default_procedure_for_element       (gpointer data,
							    gpointer func_data,
							    gpointer invoke_data);
static gpointer popup_menu_for_gtypeinstance               (gpointer data,
							    gpointer func_data,
							    gpointer invoke_data);
static gpointer popup_menu_for_gtypeclass                  (gpointer data,
							    gpointer func_data,
							    gpointer invoke_data);
static gpointer popup_menu_for_element                     (gpointer data,
							    gpointer func_data,
							    gpointer invoke_data);

#define INVOKE_DEFAULT_PROCEDURE_FOR_GTYPEINSTANCE "invoke-default-procedure-for-gtypeinstance"
#define INVOKE_DEFAULT_PROCEDURE_FOR_GTYPECLASS    "invoke-default-procedure-for-gtypeclass"
#define POPUP_MENU_FOR_GTYPEINSTANCE               "popup-menu-for-gtypeinstance"
#define POPUP_MENU_FOR_GTYPECLASS                  "popup-menu-for-gtypeclass"



void
g_inspector_builtin_register_module_misc_procedure (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-misc-procedure";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure (INVOKE_DEFAULT_PROCEDURE_FOR_GTYPEINSTANCE,
				  "",
                                  G_INSPECTOR_PROCEDURE_TYPE_MISC,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  G_TYPE_OBJECT,
				  invoke_default_procedure_for_gtypeinstance,
                                  NULL);

  g_inspector_register_procedure (INVOKE_DEFAULT_PROCEDURE_FOR_GTYPECLASS,
				  "",
                                  G_INSPECTOR_PROCEDURE_TYPE_MISC,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE, /* XXX */
				  invoke_default_procedure_for_gtypeclass,
                                  NULL);

  g_inspector_register_procedure (POPUP_MENU_FOR_GTYPEINSTANCE,
				  "",
                                  G_INSPECTOR_PROCEDURE_TYPE_MISC,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  G_TYPE_OBJECT,
				  popup_menu_for_gtypeinstance,
                                  NULL);

  g_inspector_register_procedure (POPUP_MENU_FOR_GTYPECLASS,
				  "",
                                  G_INSPECTOR_PROCEDURE_TYPE_MISC,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE, /* XXX */
				  popup_menu_for_gtypeclass,
                                  NULL);


  g_inspector_register_procedure ("invoke-default-procedure-for-element",
				  "",
                                  G_INSPECTOR_PROCEDURE_TYPE_MISC,
                                  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE, /* XXX */
				  invoke_default_procedure_for_element,
                                  NULL);

  g_inspector_register_procedure ("popup-menu-for-element",
				  "",
                                  G_INSPECTOR_PROCEDURE_TYPE_MISC,
                                  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE, /* XXX */
				  popup_menu_for_element,
                                  NULL);
}



static GList*
grep_procedure_info_by_procedure_type (GList                   *procedure_info_list,
				       GInspectorProcedureType  procedure_type)
{
  GList *tmp;
  GInspectorProcedureInfo *tmp_info;
  GList *match_info_list;

  
  match_info_list = NULL;

  tmp = procedure_info_list;
  while (tmp != NULL)
    {
      tmp_info = tmp->data;
      tmp = g_list_next (tmp);

      if (tmp_info->procedure_type == procedure_type)
	{
	  match_info_list = g_list_append (match_info_list,
					   tmp_info);
	}
    }

  return match_info_list;
}

static GList*
grep_procedure_info_by_target_element_type (GList                 *procedure_info_list,
					    GInspectorElementType  target_element_type)
{
  GList *tmp;
  GInspectorProcedureInfo *tmp_info;
  GList *match_info_list;


  match_info_list = NULL;

  tmp = procedure_info_list;
  while (tmp != NULL)
    {
      tmp_info = tmp->data;
      tmp = g_list_next (tmp);

      if (tmp_info->target_element_type == target_element_type)
	{
	  match_info_list = g_list_append (match_info_list,
					   tmp_info);
	}
    }

  return match_info_list;
}

static GList*
get_procedure_info_list_for_gtypeinstance (GTypeInstance *instance)
{
  GList *tmp;
  GType tmp_type;
  GInspectorProcedureInfo *tmp_info;
  GList *tmp_procedure_info_list;
  GList *match_info_list;

  {
    GList *procedure_info_list;
    GList *tmp1;
    GList *tmp2;

    procedure_info_list = g_inspector_get_procedure_info_list ();

    tmp1 = grep_procedure_info_by_target_element_type (procedure_info_list,
						       G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE);

    tmp2 = NULL;
    tmp2 = g_list_concat (tmp2,
			  grep_procedure_info_by_procedure_type
						(tmp1,
						 G_INSPECTOR_PROCEDURE_TYPE_WINDOW));
    tmp2 = g_list_concat (tmp2,
			  grep_procedure_info_by_procedure_type
						(tmp1,
						 G_INSPECTOR_PROCEDURE_TYPE_MISC));

    g_list_free (tmp1);
    tmp_procedure_info_list = tmp2;
  }


  match_info_list = NULL;

  tmp_type = G_TYPE_FROM_INSTANCE (instance);
  while (tmp_type != 0)
    {
      tmp = tmp_procedure_info_list;
      while (tmp != NULL)
	{
	  tmp_info = tmp->data;
	  tmp = g_list_next (tmp);

	  if (tmp_info->gtype == tmp_type)
	    {
	      match_info_list = g_list_append (match_info_list,
					       tmp_info);
	    }
	}

      tmp_type = g_type_parent (tmp_type);
    }

  tmp = tmp_procedure_info_list;
  while (tmp != NULL)
    {
      tmp_info = tmp->data;
      tmp = g_list_next (tmp);

      if (tmp_info->gtype == G_TYPE_NONE)
	{
	  match_info_list = g_list_append (match_info_list,
					   tmp_info);
	}
    }


  if (tmp_procedure_info_list != NULL)
    {
      g_list_free (tmp_procedure_info_list);
    }


  return match_info_list;
}

static GList*
get_procedure_info_list_for_gtypeclass (GType type)
{
  GList *tmp;
  GType tmp_type;
  GInspectorProcedureInfo *tmp_info;
  GList *tmp_procedure_info_list;
  GList *match_info_list;

  {
    GList *procedure_info_list;
    GList *tmp1;
    GList *tmp2;

    procedure_info_list = g_inspector_get_procedure_info_list ();

    tmp1 = grep_procedure_info_by_target_element_type (procedure_info_list,
						       G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS);

    tmp2 = NULL;
    tmp2 = g_list_concat (tmp2,
			  grep_procedure_info_by_procedure_type
						(tmp1,
						 G_INSPECTOR_PROCEDURE_TYPE_WINDOW));
    tmp2 = g_list_concat (tmp2,
			  grep_procedure_info_by_procedure_type
						(tmp1,
						 G_INSPECTOR_PROCEDURE_TYPE_MISC));

    g_list_free (tmp1);
    tmp_procedure_info_list = tmp2;
  }


  match_info_list = NULL;

  tmp_type = type;
  while (tmp_type != 0)
    {
      tmp = tmp_procedure_info_list;
      while (tmp != NULL)
	{
	  tmp_info = tmp->data;
	  tmp = g_list_next (tmp);

	  if (tmp_info->gtype == tmp_type)
	    {
	      match_info_list = g_list_append (match_info_list,
					       tmp_info);
	    }
	}

      tmp_type = g_type_parent (tmp_type);
    }

  tmp = tmp_procedure_info_list;
  while (tmp != NULL)
    {
      tmp_info = tmp->data;
      tmp = g_list_next (tmp);

      if (tmp_info->gtype == G_TYPE_NONE)
	{
	  match_info_list = g_list_append (match_info_list,
					   tmp_info);
	}
    }


  if (tmp_procedure_info_list != NULL)
    {
      g_list_free (tmp_procedure_info_list);
    }


  return match_info_list;
}

static GList*
remove_info_from_list_by_name (GList *info_list,
			       gchar *procedure_name)
{
  GList *tmp;
  GList *tmp2;
  GInspectorProcedureInfo *tmp_info;

  tmp_info = NULL;

  tmp = info_list;
  tmp2 = info_list;
  while (tmp != NULL)
    {
      tmp_info = tmp->data;
      tmp = g_list_next (tmp);

      if (strcmp (tmp_info->name, procedure_name) == 0)
	{
	  tmp2 = g_list_remove (info_list, tmp_info);
	  break;
	}
    }

  return tmp2;
}

static gpointer
invoke_default_procedure_for_gtypeinstance (gpointer data,
					    gpointer func_data,
					    gpointer invoke_data)
{
  GTypeInstance *instance;
  GList *tmp;
  gpointer r;

  instance = (GTypeInstance *)data;


  tmp = get_procedure_info_list_for_gtypeinstance (instance);
  tmp = remove_info_from_list_by_name (tmp, INVOKE_DEFAULT_PROCEDURE_FOR_GTYPEINSTANCE);

  if (tmp != NULL)
    {
      GInspectorProcedureInfo *info;

      info = tmp->data;

      r = (* info->func) (instance, info->func_data, invoke_data);
    }
  else
    {
      r = NULL;
    }

  if (tmp != NULL)
    {
      g_list_free (tmp);
    }

  return r;
}

static gpointer
invoke_default_procedure_for_gtypeclass (gpointer data,
					 gpointer func_data,
					 gpointer invoke_data)
{
  GType  type;
  GList *tmp;
  gpointer r;


  type = GPOINTER_TO_TYPE (data);


  tmp = get_procedure_info_list_for_gtypeclass (type);
  tmp = remove_info_from_list_by_name (tmp, INVOKE_DEFAULT_PROCEDURE_FOR_GTYPECLASS);

  if (tmp != NULL)
    {
      GInspectorProcedureInfo *info;

      info = tmp->data;

      r = (* info->func) (GTYPE_TO_POINTER (type), info->func_data, invoke_data);
    }
  else
    {
      r = NULL;
    }

  if (tmp != NULL)
    {
      g_list_free (tmp);
    }


  return r;
}


static gpointer
invoke_default_procedure_for_element (gpointer data,
				      gpointer func_data,
				      gpointer invoke_data)
{
  GInspectorElementHolder *element_holder;
  GInspectorElementType element_type;
  gpointer element;
  gpointer r;

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (data);

  element_type = g_inspector_element_holder_get_element_type (element_holder);
  element = g_inspector_element_holder_get_element (element_holder);

  switch (element_type)
    {
    case G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE:
      {
	r = invoke_default_procedure_for_gtypeinstance (element, func_data, invoke_data);
      }
      break;

    case G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS:
      {
	r = invoke_default_procedure_for_gtypeclass (element, func_data, invoke_data);
      }
      break;

    default:
      {
	r = NULL;
      }
      break;
    }

  return r;
}




#define INSPECTOR_PROCEDURE_INFO "GInspectorProcedureInfo"

static void
menu_item_activate (GtkMenuItem *menu_item,
		    gpointer     user_data)
{
  GInspectorProcedureInfo *info;
  GInspectorElementHolder *element_holder;
  gpointer element;

  info = (GInspectorProcedureInfo *)g_object_get_data (G_OBJECT (menu_item),
						       INSPECTOR_PROCEDURE_INFO);

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (user_data);
  element = g_inspector_element_holder_get_element (element_holder);

  (* info->func) (element, info->func_data, NULL);
}

static void
construct_menu_with_procedure_info_list (GtkMenuShell            *menu_shell,
					 GList                   *procedure_info_list,
					 GInspectorElementHolder *element_holder)
{
  {
    gtk_container_foreach (GTK_CONTAINER (menu_shell),
			   (GtkCallback)gtk_widget_destroy,
			   NULL);
  }

  {
    GList *tmp;
    GInspectorProcedureInfo *info;
    GtkWidget *menu_item;


    tmp = procedure_info_list;
    while (tmp != NULL)
      {
	info = tmp->data;
	tmp = g_list_next (tmp);

	menu_item = gtk_menu_item_new_with_label (info->detail);

	g_object_set_data (G_OBJECT (menu_item),
			   INSPECTOR_PROCEDURE_INFO, info);

	g_signal_connect (menu_item,
			  "activate",
			  G_CALLBACK (menu_item_activate),
			  element_holder);

	gtk_menu_shell_append (menu_shell, menu_item);
      }

    gtk_widget_show_all (GTK_WIDGET (menu_shell));
  }
}

static void
construct_menu_for_element (GtkMenuShell            *menu_shell,
			    GInspectorElementHolder *element_holder)
{
  GInspectorElementType element_type;
  gpointer element;

  element_type = g_inspector_element_holder_get_element_type (element_holder);
  element = g_inspector_element_holder_get_element (element_holder);

  switch (element_type)
    {
    case G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE:
      {
	GList *tmp;
	
	tmp = get_procedure_info_list_for_gtypeinstance (element);
	tmp = remove_info_from_list_by_name (tmp, INVOKE_DEFAULT_PROCEDURE_FOR_GTYPEINSTANCE);
	tmp = remove_info_from_list_by_name (tmp, POPUP_MENU_FOR_GTYPEINSTANCE);

	construct_menu_with_procedure_info_list (menu_shell, tmp, element_holder);

	if (tmp != NULL)
	  {
	    g_list_free (tmp);
	  }
      }
      break;

    case G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS:
      {
	GList *tmp;
	
	tmp = get_procedure_info_list_for_gtypeclass (GPOINTER_TO_TYPE (element));
	tmp = remove_info_from_list_by_name (tmp, INVOKE_DEFAULT_PROCEDURE_FOR_GTYPECLASS);
	tmp = remove_info_from_list_by_name (tmp, POPUP_MENU_FOR_GTYPECLASS);

	construct_menu_with_procedure_info_list (menu_shell, tmp, element_holder);

	if (tmp != NULL)
	  {
	    g_list_free (tmp);
	  }
      }
      break;

    default:
      break;
    }
}

static gpointer
popup_menu_for_element (gpointer data,
			gpointer func_data,
			gpointer invoke_data)
{
  GInspectorElementHolder *element_holder;
  GtkWidget *menu;
  GdkEventButton *event;

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (data);


  event = (GdkEventButton *)invoke_data;

  {
    menu = gtk_menu_new ();
    g_inspector_tag_to_widget (gtk_widget_get_toplevel (menu));

    construct_menu_for_element (GTK_MENU_SHELL (menu), element_holder);
  }

  {
    g_object_ref (menu);
    gtk_object_sink (GTK_OBJECT (menu));
    g_signal_connect (menu,
		      "selection-done",
		      G_CALLBACK (g_object_unref),
		      NULL);
  }

  {
    guint button;
    guint32 activate_time;

    if (event != NULL)
      {
	button        = event->button;
	activate_time = event->time;
      }
    else
      {
	button        = 0;
	activate_time = GDK_CURRENT_TIME;
      }


    gtk_menu_popup (GTK_MENU (menu),
		    NULL,
		    NULL,
		    NULL,
		    NULL,
		    button,
		    activate_time);
  }

  return NULL;
}




static gpointer
popup_menu_for_gtypeinstance (gpointer data,
			      gpointer func_data,
			      gpointer invoke_data)

{
  GTypeInstance *instance;
  GInspectorElementHolder *element_holder;
  gpointer r;


  instance = (GTypeInstance *)data;

  element_holder = g_inspector_element_holder_new ();

  g_inspector_element_holder_set_gtypeinstance (element_holder,
						instance);

  r = popup_menu_for_element (element_holder,
			      func_data,
			      invoke_data);

  g_object_unref (element_holder);


  return r;
}

static gpointer
popup_menu_for_gtypeclass (gpointer data,
			   gpointer func_data,
			   gpointer invoke_data)
{
  GType type;
  GInspectorElementHolder *element_holder;
  gpointer r;


  type = GPOINTER_TO_TYPE (data);


  element_holder = g_inspector_element_holder_new ();

  g_inspector_element_holder_set_gtype (element_holder,
					type);

  r = popup_menu_for_element (element_holder,
			      func_data,
			      invoke_data);

  g_object_unref (element_holder);


  return r;
}
