/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_TRANSFER_CB_H__
#define __UI_TRANSFER_CB_H__

#include "event.h"
#include "ui_transfer.h"

typedef enum
{
	/* Displayed */
	TRANSFER_FILENAME = 0,
	TRANSFER_PROGRESS,
	TRANSFER_SIZE,
	TRANSFER_SPEED,
	TRANSFER_STATE,
	
	/* Not */
	TRANSFER_URL,
	TRANSFER_HASH,
	TRANSFER_START,
	TRANSFER_TRANSMIT,
	TRANSFER_FILESIZE,
	TRANSFER_TRSPEED,
	TRANSFER_ICON,
	TRANSFER_ID,
	
	/* property */
	TRANSFER_COLOR,
	
	TRANSFER_NUMBER
} GiftuiTransferColumn_t;

void giftui_transfer_updownload_add (GiftuiTransfer *tr, GiftuiEvent_t *in);
void giftui_transfer_updownload_update (GiftuiTransfer *tr, GiftuiEvent_t *in);
void giftui_transfer_updownload_del (GiftuiTransfer *tr, GiftuiEvent_t *in);
void giftui_transfer_locate_sources (GiftuiTransfer *tr, GiftuiEvent_t *in);
void giftui_transfer_update_colors (GiftuiTransfer *tr);

#endif
