/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_TRANSFER_H__
#define __UI_TRANSFER_H__

#include <gtk/gtk.h>

#include "ui_child.h"

/*
  GiftuiChild
      +----GiftuiTransfer
*/

#define GIFTUI_TYPE_TRANSFER (giftui_transfer_get_type ())
#define GIFTUI_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIFTUI_TYPE_TRANSFER, GiftuiTransfer))
#define GIFTUI_TRANSFER_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), GIFTUI_TYPE_TRANSFER, GiftuiTransferClass))
#define GIFTUI_IS_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIFTUI_TYPE_TRANSFER))
#define GIFTUI_IS_TRANSFER_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), GIFTUI_TYPE_TRANSFER))
#define GIFTUI_TRANSFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GIFTUI_TYPE_TRANSFER, GiftuiTransferClass))

#define GIFTUI_TRANSFERFILE(arg) ((GiftuiTransferFile_t *) (arg))

typedef struct _GiftuiTransfer GiftuiTransfer;
typedef struct _GiftuiTransferClass GiftuiTransferClass;

typedef struct _GiftuiTransferFile_t GiftuiTransferFile_t;
typedef struct _GiftuiTransferChunk_t GiftuiTransferChunk_t;

struct _GiftuiTransfer
{
	GiftuiChild parent_instance;
	
	/* < private_data > */
	GtkWidget *paned;
	GtkWidget *up_list;
	GtkWidget *down_list;
	GtkWidget *current_list; /* list where popup has been
				  * popup. */
	
	GtkWidget *popup;
	
	/* Up&Download stats */
	guint stats_timeout;
	gboolean stats_updated : 1;
	GtkWidget *up_stats;
	GtkWidget *down_stats;
};

struct _GiftuiTransferClass
{
	GiftuiChildClass parent_class;
};

struct _GiftuiTransferFile_t
{
	GtkWidget *treeview;
	GtkTreeModel *model;
	GtkTreeIter parent;
	GtkTreeIter child;
	
       	gchar *str_file;
	gchar *str_size;
	gchar *str_user;
	gchar *str_state;
	gchar *str_hash;
	gchar *str_url;
	gchar *str_speed;
	
       	guint percent;
	guint status;
	gulong speed;
	gulong filesize;
	gulong transmit;
	gulong throughput;
       	gulong elapsed;
};

struct _GiftuiTransferChunk_t
{
	gchar *str_size;
	gchar *str_user;
	gchar *str_state;
	gchar *str_url;
	gchar *str_speed;
	
	guint percent;
	gulong speed;
	gulong start;
	gulong transmit;
	gulong throughput;
	gulong elapsed;
};

GType giftui_transfer_get_type (void);
GtkWidget *giftui_transfer_new (void);

/* Way to download file and store informations. */
void giftui_transferfile_free_data (GiftuiTransferFile_t *f);
void giftui_transferfile_free (GiftuiTransferFile_t *f);
void giftui_transferfile_download (GiftuiTransferFile_t *f);

#endif
