/* $Header: /cvs/gnome/gIDE/src/gI_help.c,v 1.3 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-200-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include <string.h>
#include <unistd.h>
#include "structs.h"
#include "gI_common.h"
#include "gI_help.h"
#include "help.h"

#include <stdlib.h>

/* globals */
static GtkWidget *help_window = NULL;
static GtkWidget *e_mp, *e_section;

/* externs */
extern char gide_path[];
extern gI_config *cfg;


static void help_window_destroy( GtkWidget *widget, gpointer data )
{
    gtk_widget_destroy( help_window );
    help_window = NULL;
}


void show_help( GtkWidget *widget, gpointer data )
{
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *hsep;
    GtkWidget *button;
    GtkWidget *text;
    GtkWidget *vscrollbar;
    long i;

    if( help_window )
        return;

    help_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    gtk_widget_set_usize( help_window, 400, 400 );
    gtk_window_set_title( GTK_WINDOW( help_window ), _("Help") );
    gtk_signal_connect( GTK_OBJECT( help_window ), "destroy",
                        GTK_SIGNAL_FUNC( help_window_destroy ), NULL );

    vbox = gtk_vbox_new( FALSE, 0 );
    gtk_container_add( GTK_CONTAINER( help_window ), vbox );
    gtk_widget_show( vbox );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 5 );
    gtk_widget_show( hbox );
    
    text = gtk_text_new( NULL, NULL );
    gtk_box_pack_start( GTK_BOX( hbox ), text, TRUE, TRUE, 5 );
    gtk_widget_show( text );

    vscrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
    gtk_box_pack_end( GTK_BOX( hbox ), vscrollbar, FALSE, TRUE, 5 );
    gtk_widget_show( vscrollbar );

    hsep = gtk_hseparator_new();
    gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
    gtk_widget_show( hsep );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
    gtk_widget_show( hbox );

    button = gnome_stock_button( GNOME_STOCK_BUTTON_CLOSE );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
    gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                        GTK_SIGNAL_FUNC( help_window_destroy ), NULL );
    GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
    gtk_widget_grab_default( button );
    gtk_widget_show( button );

    gtk_widget_show( help_window );

    /* insert text */
    gtk_text_freeze( GTK_TEXT( text ) );
    for(i=0;i<(sizeof( help_text ) / sizeof( help_text[0] ) );i++)
        gtk_text_insert( GTK_TEXT( text ), NULL, &text->style->black, NULL, help_text[i], strlen( help_text[i] ) );
    gtk_text_thaw( GTK_TEXT( text ) );
}


static void help_man_page_ok( GtkWidget *widget, gpointer data )
{
	char *mp, *section;

	mp = gtk_entry_get_text( GTK_ENTRY( e_mp ) );
	if( !mp || isempty( mp ) )
		return;

	section = gtk_entry_get_text( GTK_ENTRY( e_section ) ); 
	if( !section || isempty( section ) )
	{
		gman( mp, NULL ); 
		return;
	}
	else
	{
		gman( mp, section ); 
		return;
	}
}


void help_man_page( GtkWidget *widget, gpointer data )
{
	/*entry_dialog( "Enter page: ", "Help - Manual Page", help_man_page_ok );*/

	GtkWidget *button, *wlabel;
	static GtkWidget *dialog_window;
	GtkWidget *hbox;
 
	dialog_window = gtk_dialog_new();
	gtk_signal_connect( GTK_OBJECT( dialog_window ), "destroy",
					    GTK_SIGNAL_FUNC( gtk_widget_destroyed ),
					    &dialog_window );
  	gtk_container_border_width( GTK_CONTAINER( dialog_window ), 15 ); 
    	gtk_window_set_title( GTK_WINDOW( dialog_window ), _("Help - Manual Page") );
	gtk_window_position( GTK_WINDOW( dialog_window ), GTK_WIN_POS_MOUSE );
  
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog_window )->vbox ),
					   hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );
 
	wlabel = gtk_label_new( _("Manual Page ") );
	gtk_box_pack_start( GTK_BOX( hbox ), wlabel, FALSE, TRUE, 5 );
	gtk_widget_show( wlabel );

	e_mp = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_mp, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( e_mp ), "activate",
					    GTK_SIGNAL_FUNC( help_man_page_ok ), NULL );
	gtk_signal_connect_object( GTK_OBJECT( e_mp ), "activate",
							   GTK_SIGNAL_FUNC( gtk_widget_destroy ),
							   GTK_OBJECT( dialog_window ) );
	gtk_widget_grab_focus( e_mp );	
	gtk_widget_show( e_mp );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog_window )->vbox ),
					   hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	wlabel = gtk_label_new( _("Section     ") );
	gtk_box_pack_start( GTK_BOX( hbox ), wlabel, FALSE, TRUE, 5 );
	gtk_widget_show( wlabel );

	e_section = gtk_entry_new_with_max_length( 5 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_section, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( e_section ), "activate",
					    GTK_SIGNAL_FUNC( help_man_page_ok ), NULL );
	gtk_signal_connect_object( GTK_OBJECT( e_section ), "activate",
							   GTK_SIGNAL_FUNC( gtk_widget_destroy ),
							   GTK_OBJECT( dialog_window ) );
	gtk_widget_show( e_section );	
	
        button = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog_window )->action_area),
					    button, TRUE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
    				    GTK_SIGNAL_FUNC( help_man_page_ok ), NULL );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
						    GTK_SIGNAL_FUNC( gtk_widget_destroy ),
						    GTK_OBJECT( dialog_window ) );
    	GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
    	gtk_widget_grab_default( button );
	gtk_widget_show( button );
	

        button = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog_window )->action_area),
					    button, TRUE, TRUE, 5 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
						    GTK_SIGNAL_FUNC( gtk_widget_destroy ),
						    GTK_OBJECT( dialog_window ) );
	gtk_widget_show( button );

	gtk_widget_show( dialog_window );
}

/* convert a selection into something usable by gman() */
void man_page_click( GtkWidget *widget, gpointer this ) {
	static GdkAtom targets_atom = GDK_NONE;
	
	if (targets_atom == GDK_NONE)
		targets_atom = gdk_atom_intern ("TEXT", FALSE);
	gtk_main_iteration();
	gtk_selection_convert (widget, GDK_SELECTION_PRIMARY, targets_atom,
						   GDK_CURRENT_TIME);
}

/* call gman() with data from man_page_click() then unselect selection */
void man_sel_recv( GtkWidget *widget, GtkSelectionData *selection_data,
					gpointer this ) {
	if (selection_data->length <= 0)
		return; 
	gman(selection_data->data, NULL);
	gtk_selection_owner_set (NULL, GDK_SELECTION_PRIMARY, GDK_CURRENT_TIME);


}

/* Read in text from entry box, and then goto corresponding man page */
void man_goto( GtkWidget *widget, GtkEntry *entry ) {
	gman(gtk_entry_get_text(entry), NULL);
}

typedef struct {
	GtkEntry	*entry;
	GtkText		*text;
	GdkFont		*normal;
	GdkFont		*bold;
	GtkWidget	**sec;
	GtkMenu		*sec_menu;
} text_entry_st;

/* List releated man pages */
void man_apro( GtkWidget *widget, text_entry_st *tes ) {
	char cmdstr[256], line[1024];
	FILE *fp;

	/* gdk_window_set_cursor (tes->text->window, gdk_cursor_new (GDK_WATCH));
	*/

	while( gtk_events_pending() )
		gtk_main_iteration();

	gtk_text_set_point( GTK_TEXT(tes->text), 0 );
	gtk_text_forward_delete ( GTK_TEXT(tes->text),
							  gtk_text_get_length( GTK_TEXT(tes->text) ) );
	g_snprintf( cmdstr, sizeof(cmdstr), "%s %s", "apropos", 
				gtk_entry_get_text(tes->entry) ); 
	fp = popen( cmdstr, "r" );

	if( feof( fp ) )
	{
		fprintf( stderr, "Could not execute apropos...\n" );
		return;
	}

	gtk_text_freeze(GTK_TEXT(tes->text));

	if ( fgets( line, sizeof(line), fp ) == 0 ) {
		gtk_text_insert (GTK_TEXT (tes->text), tes->bold, NULL, NULL,
					 "\n\n\tCould not find any related man pages!!\n\n\n", -1);
		gtk_text_insert (GTK_TEXT (tes->text), tes->normal, NULL, NULL,
						 "You might need to create a whatis database, see", -1);
		gtk_text_insert (GTK_TEXT (tes->text), tes->bold, NULL, NULL,
						 " makewhatis", -1);
	}
	else
		while( 	fgets( line, sizeof(line), fp ) ) {
			if ( strlen(line) > 75 ) {
				gtk_text_insert (GTK_TEXT (tes->text), tes->normal, 
								 NULL, NULL, line , 75); 
				gtk_text_insert (GTK_TEXT (tes->text), tes->normal, 
							 	 NULL, NULL, "...\n" , -1); 
			}
			else
				gtk_text_insert (GTK_TEXT (tes->text), tes->normal, 
								 NULL, NULL, line , -1); 
		}

	gtk_text_thaw(GTK_TEXT(tes->text));
}

/* list an index of man pages */
void man_indx( GtkWidget *widget, text_entry_st *tes ) {
	char Section[10],temp[60];
	int i = 0;

	while ( (gtk_menu_get_active(tes->sec_menu) != tes->sec[++i]) && (i < 10));

	if ( i < 10 ) {
		sprintf(Section, "\'(%d)\'", i);
		sprintf(temp,"%s",gtk_entry_get_text(tes->entry));
		gtk_entry_set_text(tes->entry,Section);
		man_apro( widget, tes );
		gtk_entry_set_text(tes->entry,temp);
	} else { /* What, No section selected!!?? */
		gtk_text_set_point( GTK_TEXT(tes->text), 0 );
		gtk_text_forward_delete ( GTK_TEXT(tes->text),
								  gtk_text_get_length( GTK_TEXT(tes->text) ) );
	
		gtk_text_insert (GTK_TEXT (tes->text), tes->bold, NULL, NULL,
						 "\n\n\tYou need to select a section first.", -1);
		gtk_text_set_editable( GTK_TEXT (tes->text), FALSE );
	}
			
}

/* gman: man page viewer by The Bear <bear@berkeleycs.ml.org>,
	slightly modified by Steffen Kern <alfi@rocks.pn.org> */
void gman( char *mp, char *section )
{
	static GtkWidget *vbox_main = NULL;
	static GtkWidget *window = NULL;
	static GtkWidget *event_box = NULL;
	static GtkWidget *hbox = NULL;
	static GtkWidget *text = NULL;
	static GtkWidget *text_entry = NULL;
	static GtkWidget *vscrollbar = NULL, *hbox_man_ctrls, *but_goto, *but_apro,
					 *section_menu = NULL, *section_opt,
					 *sec_any, **sec, *but_indx;
	static GdkFont *normal = NULL, *bold = NULL;
	text_entry_st *tes;

	int n, i, bold_flag = 0;
	char line[81], temp_string[5];
	FILE *fp;
	char cmdstr[256];



	if ( (window == NULL) || (window->window == NULL) )  {
		window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title( GTK_WINDOW( window ), _("Manual Page Viewer") );
		gtk_widget_set_usize( window, 600, 600 );
 
		gtk_container_border_width (GTK_CONTAINER (window), 10);

 
	/* This might not be the cleanest way of doing this, I am open to
	 * suggestions here.... ( email me at bear@berkeleycs.ml.org )
	 * what it does basically is make an event box, that calls
	 * man_page_click() whenever anyone clicks on the text box.
	 * man_page_click(), converts whatever is selected into something
	 * usable my man_sel_recv(), man_sel_recv() then tries to call
	 * gman() with selected data */

		vbox_main = gtk_vbox_new( FALSE, 0 );
		gtk_container_add ( GTK_CONTAINER( window ), vbox_main );

		event_box = gtk_event_box_new ();
		gtk_widget_set_usize( event_box, 600, 550 );
		gtk_container_add ( GTK_CONTAINER( vbox_main ), event_box);
		hbox = gtk_hbox_new( FALSE, 0 );
		gtk_container_add( GTK_CONTAINER( event_box ), hbox );

		text = gtk_text_new( NULL, NULL );
		gtk_box_pack_start( GTK_BOX( hbox ), text, TRUE, TRUE, 2 );

		vscrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
		gtk_box_pack_start( GTK_BOX( hbox ), vscrollbar, FALSE, FALSE, 0 );

		/* FIXME: We should let the user select which font they want */

		normal = gdk_font_load ("-misc-fixed-medium-r-normal-*-*-120-*-*-c-*-iso8859-1");
		bold = gdk_font_load ("-misc-fixed-bold-r-normal-*-*-120-*-*-c-*-iso8859-1");

		hbox_man_ctrls = gtk_hbox_new( FALSE, 4 );
		gtk_container_add( GTK_CONTAINER( vbox_main ), hbox_man_ctrls );

		text_entry = gtk_entry_new_with_max_length(45);
		/* gtk_entry_set_text(GTK_ENTRY(text_entry), mp); */
		but_goto = gtk_button_new_with_label( _("Go To Manpage") );
		but_apro = gtk_button_new_with_label( _("List Related") );

		gtk_widget_get_name(but_goto);

		section_opt = gtk_option_menu_new();
		section_menu = gtk_menu_new();
		sec_any = gtk_menu_item_new_with_label( _("All Sections") );

		sec = g_malloc0( sizeof ( GtkWidget* ) * 10 );

		sec[1] = gtk_menu_item_new_with_label( _("1 - User Commands") );
		sec[2] = gtk_menu_item_new_with_label( _("2 - System Calls") );
		sec[3] = gtk_menu_item_new_with_label( _("3 - Subroutines") );
		sec[4] = gtk_menu_item_new_with_label( _("4 - Devices") );
		sec[5] = gtk_menu_item_new_with_label( _("5 - File Formats") );
		sec[6] = gtk_menu_item_new_with_label( _("6 - Games") );
		sec[7] = gtk_menu_item_new_with_label( _("7 - Miscellaneous") );
		sec[8] = gtk_menu_item_new_with_label( _("8 - Sys. Administration") );
		sec[9] = gtk_menu_item_new_with_label( _("9 - Kernel Interfaces") );
		sec[0] = gtk_menu_item_new_with_label( _("n - New") );

		but_indx = gtk_button_new_with_label( _("Index") );


		gtk_menu_append( GTK_MENU(section_menu), sec_any);
		gtk_menu_append( GTK_MENU(section_menu), sec[1]);
		gtk_menu_append( GTK_MENU(section_menu), sec[2]);
		gtk_menu_append( GTK_MENU(section_menu), sec[3]);
		gtk_menu_append( GTK_MENU(section_menu), sec[4]);
		gtk_menu_append( GTK_MENU(section_menu), sec[5]);
		gtk_menu_append( GTK_MENU(section_menu), sec[6]);
		gtk_menu_append( GTK_MENU(section_menu), sec[7]);
		gtk_menu_append( GTK_MENU(section_menu), sec[8]);
		gtk_menu_append( GTK_MENU(section_menu), sec[9]);
		/* gtk_menu_append( GTK_MENU(section_menu), sec_n); */

		gtk_option_menu_set_menu( GTK_OPTION_MENU( section_opt ), section_menu );

		gtk_box_pack_start( GTK_BOX( hbox_man_ctrls ), text_entry,TRUE,TRUE,2);
		gtk_box_pack_start( GTK_BOX( hbox_man_ctrls ), but_goto,FALSE,FALSE,0 );
		gtk_box_pack_start( GTK_BOX( hbox_man_ctrls ), but_apro,FALSE,FALSE,0 );
		gtk_box_pack_start( GTK_BOX( hbox_man_ctrls ), section_opt,TRUE,TRUE,0);
		gtk_box_pack_start( GTK_BOX( hbox_man_ctrls ), but_indx,FALSE,FALSE,0 );



		gtk_widget_set_events ( event_box, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect (GTK_OBJECT(event_box), "button_release_event",
							GTK_SIGNAL_FUNC (man_page_click), NULL);
		gtk_signal_connect (GTK_OBJECT(event_box), "selection_received",
							GTK_SIGNAL_FUNC (man_sel_recv), window);
		gtk_signal_connect (GTK_OBJECT( but_goto ), "clicked",
							GTK_SIGNAL_FUNC (man_goto), text_entry);

		tes = g_malloc0(sizeof(GtkEntry*)+sizeof(GtkText*)+2*sizeof(GdkFont*)+5);
		tes->entry = GTK_ENTRY(text_entry);
		tes->text = GTK_TEXT(text);
		tes->normal = normal;
		tes->bold = bold;
		tes->sec = sec;
		tes->sec_menu = GTK_MENU(section_menu);

		gtk_signal_connect (GTK_OBJECT( but_apro ), "clicked",
							GTK_SIGNAL_FUNC (man_apro), tes);
		gtk_signal_connect (GTK_OBJECT( but_indx ), "clicked",
							GTK_SIGNAL_FUNC (man_indx), tes);

		gtk_widget_grab_focus( text_entry );	
		gtk_signal_connect( GTK_OBJECT( text_entry ), "activate",
					    GTK_SIGNAL_FUNC( man_goto ), text_entry );

		gtk_adjustment_set_value( GTK_TEXT( text )->vadj, 1 );

	}

	i = 0;
	/* Set section chosen in option menu */
	if ( gtk_menu_get_active(GTK_MENU(section_menu)) != sec_any ) {
		while ( gtk_menu_get_active(GTK_MENU(section_menu)) != sec[++i] );
		/* Fixme: Does not work for man pages in section 'n' */
		section = g_malloc0( sizeof(char) * 2 ); /* is this needed? */
		sprintf(section, "%d", i);
		i = 0;
	}

	if( !section )
	{
		g_snprintf( cmdstr, sizeof(cmdstr), "%s %s", cfg->man, mp );
	}
	else
	{
		g_snprintf( cmdstr, sizeof(cmdstr), "%s %s %s", cfg->man, section, mp );
		g_free( section );
		section = NULL;
	}

	/*g_free( sec );*/

	if ( event_box->window != NULL)
		gdk_window_set_cursor (event_box->window, gdk_cursor_new (GDK_WATCH));

	while( gtk_events_pending() )
		gtk_main_iteration();

	fp = popen( cmdstr, "r" );
	if( !fp )
	{
		perror( "popen" );
		return;	
	}
			

	gtk_text_set_editable( GTK_TEXT (text), TRUE );
	/* let popen do its work */
	/* sleep(1); */

	/* process gtk stuff */
	while( gtk_events_pending() )
		gtk_main_iteration();

	if( feof( fp ) )
	{
		fprintf( stderr, "shit happens...\n" );
		return;
	}

	/* skip first line */
	fgets( line, sizeof(line), fp );

	if( !isempty( line ) )
	{
		/* error_dialog( "No manual entry found!", "Error!" ); */
		if ( event_box->window != NULL)
			gdk_window_set_cursor (event_box->window,
								   gdk_cursor_new (GDK_LEFT_PTR));
		return;
	}

	/* We have to clear all the old text before we can write */
	gtk_text_set_point( GTK_TEXT(text), 0 );
	gtk_text_forward_delete ( GTK_TEXT(text),
							  gtk_text_get_length( GTK_TEXT(text) ) );

	gtk_text_freeze(GTK_TEXT(text));
	

	while( fgets( line, sizeof(line), fp ) ) {
		n = strlen( line );
		/* The format returned by man formats bold chars by the sequence
		 * char, backspace, char. The following loop parses that sequence */

		for ( i = 0; i < n ; i++ ) 
			if ( bold_flag == 1 ) {
				sprintf(temp_string,"%c",line[i]);
				gtk_text_insert (GTK_TEXT (text), bold, 
								 &text->style->black, NULL,
                       			 temp_string , -1);
				bold_flag = 0;
			}
			else if (line[i] == 8 ) {
				gtk_text_backward_delete( GTK_TEXT (text), 1 );
				bold_flag = 1;
			}
			else
				gtk_text_insert (GTK_TEXT (text), normal,
								&text->style->black, NULL,
								&line[i] , 1);

		/* process gtk stuff */
		while( gtk_events_pending() )
			gtk_main_iteration();
	}			

	if( pclose( fp ) != 0 )
	{
		/* error */
	}


	gtk_text_thaw(GTK_TEXT(text));
	gtk_text_set_editable( GTK_TEXT (text), FALSE );

	if ( event_box->window != NULL)
		gdk_window_set_cursor (event_box->window, 
							   gdk_cursor_new (GDK_LEFT_PTR));
	gtk_widget_show_all (window);
}

