// W32_WND.CPP

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "w32_wnd.h"

#include "w32_app.h"
#include "w32_simple_dialogs.h"

#include "w32_oglview_wnd.h"

#include "w32_p1dview_wnd.h"
#include "w32_p2dview_wnd.h"
#include "w32_eldview_wnd.h"
#include "w32_rcpview_wnd.h"
#include "w32_gpcview_wnd.h"

#include "res_w32/resource.h"

#include <GL/glut.h>

#include <strstream>
using namespace std;

/*################################################################################################*/

vector<w32_wnd *> w32_wnd::iv;
const char w32_wnd::child_classname[] = "ghemical_child_wnd";

w32_wnd::w32_wnd(void) :
	base_wnd()
{
	iv.push_back(this);
	
	my_hwnd = NULL;
	my_hdc = NULL;
	
	my_hrc = NULL;
	my_popup = NULL;
	
	CREATESTRUCT cs;
	ZeroMemory(& cs, sizeof(CREATESTRUCT));
	
	my_hwnd = CreateWindowEx(
	WS_EX_MDICHILD,
	child_classname,
	"window_title_FIXME",
	WS_CHILD | WS_VISIBLE | WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT,
	CW_USEDEFAULT,
	CW_USEDEFAULT,
	CW_USEDEFAULT,
	w32_app::clientMDI_hwnd,
	NULL,
	w32_app::GetHINST(),
	& cs);
	
//	w32_app::sMessage("my_hwnd is now set!");
	
	if (!my_hwnd)
	{
		w32_app::sErrorMessage("Window creation failed : w32_wnd / my_hwnd");
	}
	else
	{
		my_hdc = GetDC(my_hwnd);
		
		if (!my_hdc)
		{
			w32_app::sErrorMessage("Window creation failed : w32_wnd / my_hdc");
		}
		else
		{
			PIXELFORMATDESCRIPTOR pfd;
			ZeroMemory(& pfd, sizeof(pfd));
			
			pfd.nSize = sizeof(pfd);
			pfd.nVersion = 1;
			pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
			pfd.iPixelType = PFD_TYPE_RGBA;
			pfd.cColorBits = 24;
			pfd.cDepthBits = 16;
			pfd.iLayerType = PFD_MAIN_PLANE;
			int format = ChoosePixelFormat(my_hdc, & pfd);
			SetPixelFormat(my_hdc, format, & pfd);
			
			my_hrc = wglCreateContext(my_hdc);
			
			if (!my_hrc)
			{
				w32_app::sErrorMessage("Window creation failed : w32_wnd / my_hrc.");
			}
			else
			{
				// success!!!
				// ^^^^^^^^^^
				
			//	ShowWindow(my_hwnd, SW_SHOW);
				ShowWindow(my_hwnd, SW_SHOWMAXIMIZED);
				
				// this will force a "mdi-tile" operation.
				// not good for a single window, but perhaps for many???
				
			//	PostMessage(w32_app::clientMDI_hwnd, WM_MDITILE, MDITILE_HORIZONTAL, 0);
			}
		}
	}
}

w32_wnd::~w32_wnd(void)
{
	w32_app::sMessage("TODO : close w32_wnd");
	
	// remove the record from iv...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	unsigned int i = 0;
	while (i < iv.size())
	{
		if (iv[i] == this) break;
		else i++;
	}
	
	if (i < iv.size())
	{
		iv.erase(iv.begin() + i);
	}
	else
	{
		w32_app::sErrorMessage("ERROR at w32_wnd dtor ; removal from iv failed!");
		exit(EXIT_FAILURE);
	}
}

bool w32_wnd::register_wnd_class(HINSTANCE hinst)
{
	WNDCLASSEX wc;
	ZeroMemory(& wc, sizeof(WNDCLASSEX));
	
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc = (WNDPROC) child_wnd_proc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hinst;
	wc.hIcon = 0;//LoadIcon(hinst, MAKEINTRESOURCE(IDI_CHILDICON));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = NULL;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = child_classname;
	wc.hIconSm = 0;//LoadIcon(hinst, MAKEINTRESOURCE(IDI_CHILDICON));
	
	if (!RegisterClassEx(& wc))
	{
		w32_app::sErrorMessage("Window registration failed : w32_wnd.");
		return false;
	}
	
	return true;
}

bool w32_wnd::unregister_wnd_class(HINSTANCE hinst)
{
	if (!UnregisterClass(child_classname, hinst))
	{
		w32_app::sErrorMessage("Window unregistration failed : w32_wnd.");
		return false;
	}
	
	return true;
}

w32_wnd * w32_wnd::iv_Find(HWND hwnd)
{
	for (unsigned int i = 0;i < iv.size();i++)
	{
		if (iv[i]->my_hwnd == hwnd) return iv[i];
	}
	
	return NULL;
}

LRESULT CALLBACK w32_wnd::child_wnd_proc(HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam)
{
	LRESULT retval = 0;
	
	static int mouseX = -1;
	static int mouseY = -1;
	
	switch(message)
	{
		case WM_PAINT:
	{	//cout << "w32_wnd/WM_PAINT" << endl << flush;
		
		// the WM_PAINT message is about window redrawing.
		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		
		PAINTSTRUCT ps;
		BeginPaint(hwnd, & ps);
		
		w32_wnd * w = iv_Find(hwnd);
		if (w == NULL || w->my_hwnd != hwnd)
		{
			w32_app::sErrorMessage("WM_PAINT error ; iv_Find() failed.");
			exit(EXIT_FAILURE);
		}
		else
		{
			bool no_errors = true;
			
			if (!w->GetRealized())
			{
				w32_app::sErrorMessage("WM_PAINT error ; not realized.");
				exit(EXIT_FAILURE);
			}
			
			if (!w->GetInitialized())
			{
				cout << "w32_wnd/WM_PAINT : not initialized!" << endl << flush;
				no_errors = false;
			}
			
			base_wcl * wcl = w->GetClient();
			if (wcl != NULL && no_errors)
			{
				if (!wglMakeCurrent(w->my_hdc, w->my_hrc))
				{
					w32_app::sErrorMessage("WM_PAINT error ; wglMakeCurrent() failed.");
				}
				else
				{
					wcl->UpdateWnd();
					
					glFlush();
					SwapBuffers(w->my_hdc);
				}
			}
		}
		
		ValidateRect(hwnd, NULL);
		EndPaint(hwnd, & ps);
		retval = 0;
		break;		}
		
		case WM_SIZE:
	{	cout << "w32_wnd/WM_SIZE" << endl << flush;
		
		// the WM_SIZE message is about window size changes.
		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		// here the problem is that my_hwnd may or may not be
		// defined when we arrive here (it won't be defined
		// at the first time when the window creation is not
		// yet finished) ; so use the WM_CREATE strategy...
		
		w32_wnd * w = iv_Find(hwnd);
		if (w == NULL || w->my_hwnd != hwnd)
		{
			// we must be here at the first time for this window.
			// just take the latest window that has been created.
			
			w = iv.back();		// get the wnd last added!!!
		}
		else
		{
			w->SetWidth(LOWORD(lparam));
			w->SetHeight(HIWORD(lparam));
		}
		
		// we need to call DefMDIChildProc() here or else
		// the MDI menus won't work properly...
		
		retval = DefMDIChildProc(hwnd, message, wparam, lparam);
		break;		}
		
		case WM_TIMER:
	{	w32_wnd * wnd = iv_Find(hwnd);
		if (!wnd) return 0;
		
		oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
		if (!wcl) return 0;
		
		// this is the graphics view idle timer event...
		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		
		GLfloat anim[3] = { wcl->animX, wcl->animY, 0.0 };
		custom_transformer_client * ctc = custom_app::GetAppC()->GetPrj();
		
		if (ctc->tc_object_ref != NULL)
		{
			ctc->tc_object_ref->OrbitObject(anim, * wcl->GetCam());
			wnd->RequestUpdate(false);
		}
		
		retval = 0;
		break;		}
		
		case WM_LBUTTONDOWN:
	{	w32_wnd * w = iv_Find(hwnd);
		if (w == NULL) cout << "w32_wnd/WM_LBUTTONDOWN : iv_Find() failed!" << endl << flush;
		else
		{
			SetCapture(hwnd);
			mouseX = LOWORD(lparam);
			mouseY = HIWORD(lparam);
			
			if (!w->GetRealized())
			{
				cout << "w32_wnd/WM_LBUTTONDOWN : NOT REALIZED!!!" << endl << flush;
				exit(EXIT_FAILURE);
			}
			
			mouseinfo::button = mouseinfo::bLeft;
			mouseinfo::state = mouseinfo::sDown;
			
			mouseinfo::shift_down = false;
			mouseinfo::ctrl_down = false;
			
			w->GetClient()->ButtonEvent(mouseX, mouseY);
		}
		retval = 0;
		break;		}
		
		case WM_LBUTTONUP:
	{	w32_wnd * w = iv_Find(hwnd);
		if (w == NULL) cout << "w32_wnd/WM_LBUTTONUP : iv_Find() failed!" << endl << flush;
		else
		{
			ReleaseCapture();
			mouseX = LOWORD(lparam);
			mouseY = HIWORD(lparam);
			
			if (!w->GetRealized())
			{
				cout << "w32_wnd/WM_LBUTTONUP : NOT REALIZED!!!" << endl << flush;
				exit(EXIT_FAILURE);
			}
			
			mouseinfo::state = mouseinfo::sUp;
			
		//	mouseinfo::shift_down = false;
		//	mouseinfo::ctrl_down = false;
			
			w->GetClient()->ButtonEvent(mouseX, mouseY);
			
			mouseinfo::button = mouseinfo::bNone;
		}
		retval = 0;
		break;		}
		
		case WM_RBUTTONDOWN:
	{	w32_wnd * w = iv_Find(hwnd);
		if (w == NULL) cout << "w32_wnd/WM_RBUTTONDOWN : iv_Find() failed!" << endl << flush;
		else
		{
		//	SetCapture(hwnd);
			mouseX = LOWORD(lparam);
			mouseY = HIWORD(lparam);
			
			if (!w->GetRealized())
			{
				cout << "w32_wnd/WM_RBUTTONDOWN : NOT REALIZED!!!" << endl << flush;
				exit(EXIT_FAILURE);
			}
			
			// show the popup-menu if one is set...
			// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
			
			if (w->my_popup != NULL)
			{
				POINT p;
				GetCursorPos(& p);
				
				TrackPopupMenu(w->my_popup,
				TPM_RIGHTBUTTON, p.x, p.y,
				0, w->my_hwnd, NULL);
			}
		}
		retval = 0;
		break;		}
		
		case WM_MOUSEMOVE:
	{	if (mouseinfo::button != mouseinfo::bNone)
		{
			w32_wnd * w = iv_Find(hwnd);
			if (w == NULL) cout << "w32_wnd/WM_LBUTTONUP : iv_Find() failed!" << endl << flush;
			else
			{
				mouseX = LOWORD(lparam);
				mouseY = HIWORD(lparam);
				
				w->GetClient()->MotionEvent(mouseX, mouseY);
			}
		}
		retval = 0;
		break;		}
		
		// put the least speed-critical ones here...
		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		
		case WM_CREATE:
	{	cout << "w32_wnd/WM_CREATE" << flush << endl;
		
		w32_wnd * w = iv.back();	// get the wnd last added!!!
		
		// at this stage the my_hwnd record is not yet set.
		// but we know that the wnd is the last one that has beed added...
		
		if (w->my_hwnd != NULL)
		{
			w32_app::sWarningMessage("WM_CREATE warning : my_hwnd is already set!");
		}
		
		w->SetRealized();
		
		// here it would be natural to do the things like these:
		// SetCurrent() + GetClient()->InitGL() + RequestUpdate(false).
		
		// the problem is that usually GetClient() will return NULL at
		// this stage ; if this is the case, then do nothing here and
		// handle the problem elsewhere (see base_wcl::LinkWnd()).
		
		// this is really a timing issue since we do not know at which
		// point the widget is going to be realized...
		
		if (w->GetClient() != NULL && !w->GetInitialized())
		{
			// usually this stuff is skipped...
			// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
			
			w->SetInitialized();
			
			w->SetCurrent();
			w->GetClient()->InitGL();
			w->RequestUpdate(false);
		}
		retval = 0;
		break;		}
		
		case WM_CLOSE:
	{	w32_wnd * w = iv_Find(hwnd);
		if (w != NULL)
		{
		/*	wglMakeCurrent(NULL, NULL);
			ReleaseDC(w->my_hwnd, w->my_hdc);
			wglDeleteContext(w->my_hrc);	*/
		}
		else w32_app::sErrorMessage("WM_CLOSE error.");
		retval = 0;
		break;		}
		
		case WM_MDIACTIVATE:
		DrawMenuBar(w32_app::frame_hwnd);
		retval = 0;
		break;
		
		case WM_COMMAND:
	{	w32_project * prj = w32_app::GetPrjX();
		
		switch (LOWORD(wparam))
		{
			// the mousetool commands:
			// ^^^^^^^^^^^^^^^^^^^^^^^
			
			case ID_MT_DRAW:
			custom_app::current_mouse_tool = custom_app::mtDraw;
			retval = 0;
			break;
			
			case ID_MT_ERASE:
			custom_app::current_mouse_tool = custom_app::mtErase;
			retval = 0;
			break;
			
			case ID_MT_SELECT:
			custom_app::current_mouse_tool = custom_app::mtSelect;
			retval = 0;
			break;
			
			case ID_MT_ZOOM:
			custom_app::current_mouse_tool = custom_app::mtZoom;
			retval = 0;
			break;
			
			case ID_MT_CLIPPING:
			custom_app::current_mouse_tool = custom_app::mtClipping;
			retval = 0;
			break;
			
			case ID_MT_TRANSLATE_XY:
			custom_app::current_mouse_tool = custom_app::mtTranslateXY;
			retval = 0;
			break;
			
			case ID_MT_TRANSLATE_Z:
			custom_app::current_mouse_tool = custom_app::mtTranslateZ;
			retval = 0;
			break;
			
			case ID_MT_ORBIT_XY:
			custom_app::current_mouse_tool = custom_app::mtOrbitXY;
			retval = 0;
			break;
			
			case ID_MT_ORBIT_Z:
			custom_app::current_mouse_tool = custom_app::mtOrbitZ;
			retval = 0;
			break;
			
			case ID_MT_ROTATE_XY:
			custom_app::current_mouse_tool = custom_app::mtRotateXY;
			retval = 0;
			break;
			
			case ID_MT_ROTATE_Z:
			custom_app::current_mouse_tool = custom_app::mtRotateZ;
			retval = 0;
			break;
			
			case ID_MT_MEASURE:
			custom_app::current_mouse_tool = custom_app::mtMeasure;
			retval = 0;
			break;
			
			// oglview commands:
			// ^^^^^^^^^^^^^^^^^
			
			case ID_FILE_OPEN:
			w32_app::sErrorMessage("todo");
			retval = 0;
			break;
			
			case ID_FILE_SAVEAS:
			w32_project::popup_FileSaveAs(hwnd);
			retval = 0;
			break;
			
			case ID_EXTRATOOLS_IMPORTPDB:
			w32_project::popup_FileExtra1(hwnd);
			retval = 0;
			break;
			
			case ID_FILE_CLOSE:
			w32_app::sErrorMessage("todo");
			retval = 0;
			break;
			
			case ID_SELECT_SEL_ALL:
			w32_project::popup_SelectAll(hwnd);
			retval = 0;
			break;
			
			case ID_SELECT_SEL_NONE:
			w32_project::popup_SelectNone(hwnd);
			retval = 0;
			break;
			
			case ID_SELECT_SEL_INVERT:
			w32_project::popup_InvertSelection(hwnd);
			retval = 0;
			break;
			
			case ID_SELMODE_ATOMS:
			w32_project::popup_SelectModeAtom(hwnd);
			retval = 0;
			break;
			
			case ID_SELMODE_RESIDUES:
			w32_project::popup_SelectModeResidue(hwnd);
			retval = 0;
			break;
			
			case ID_SELMODE_CHAINS:
			w32_project::popup_SelectModeChain(hwnd);
			retval = 0;
			break;
			
			case ID_SELMODE_MOLECULES:
			w32_project::popup_SelectModeMolecule(hwnd);
			retval = 0;
			break;
			
			case ID_SELECT_HIDE:
			w32_project::popup_HideSelected(hwnd);
			retval = 0;
			break;
			
			case ID_SELECT_SHOW:
			w32_project::popup_ShowSelected(hwnd);
			retval = 0;
			break;
			
			case ID_SELECT_LOCK:
			w32_project::popup_LockSelected(hwnd);
			retval = 0;
			break;
			
			case ID_SELECT_UNLOCK:
			w32_project::popup_UnlockSelected(hwnd);
			retval = 0;
			break;
			
			case ID_SELECT_DELETE:
			w32_project::popup_DeleteSelected(hwnd);
			retval = 0;
			break;
			
			case ID_CREATE_NEW_WIN:
			w32_oglview_wnd::popup_ViewsNewWnd(hwnd);
			retval = 0;
			break;
			
			case ID_CREATE_NEW_CAM:
			w32_oglview_wnd::popup_ViewsNewCam(hwnd);
			retval = 0;
			break;
			
			case ID_CREATE_ELD:
			w32_project::popup_ViewsNewELD(hwnd);
			retval = 0;
			break;
			
			case ID_CREATE_SSC:
			w32_project::popup_ViewsNewSSC(hwnd);
			retval = 0;
			break;
			
			case ID_VIEWS_DEL_THIS_VIEW:
			w32_oglview_wnd::popup_ViewsDeleteView(hwnd);
			retval = 0;
			break;
			
			case ID_VIEWS_SAVECRDSET:
			w32_oglview_wnd::popup_ViewsPushCRDSet(hwnd);
			retval = 0;
			break;
			
			case ID_VIEWS_SUPERIMPOSE:
			w32_oglview_wnd::popup_ViewsSuperimpose(hwnd);
			retval = 0;
			break;
			
			case ID_LIGHTS_CREATE_NEW:
			w32_oglview_wnd::popup_LightsNewLight(hwnd);
			retval = 0;
			break;
			
			case ID_LIGHTS_ENABLE_LOCAL:
			w32_oglview_wnd::popup_LightsSwitchLoc(hwnd);
			retval = 0;
			break;
			
			case ID_LIGHTS_ENABLE_GLOBAL:
			w32_oglview_wnd::popup_LightsSwitchGlob(hwnd);
			retval = 0;
			break;
			
			case ID_RENDER_BALLSTICK:
			w32_project::popup_RModeBallStick(hwnd);
			retval = 0;
			break;
			
			case ID_RENDER_VANDERWAALS:
			w32_project::popup_RModeVanDerWaals(hwnd);
			retval = 0;
			break;
			
			case ID_RENDER_CYLINDERS:
			w32_project::popup_RModeCylinders(hwnd);
			retval = 0;
			break;
			
			case ID_RENDER_WIREFRAME:
			w32_project::popup_RModeWireframe(hwnd);
			retval = 0;
			break;
			
			case ID_RENDER_NOTHING:
			w32_project::popup_RModeNothing(hwnd);
			retval = 0;
			break;
			
			case ID_COLOR_ELEMENT:
			w32_project::popup_CModeElement(hwnd);
			retval = 0;
			break;
			
			case ID_COLOR_SECSTR:
			w32_project::popup_CModeSecStruct(hwnd);
			retval = 0;
			break;
			
			case ID_COLOR_HPHOB:
			w32_project::popup_CModeHydPhob(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_INDEX:
			w32_project::popup_LModeIndex(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_FORMALCHARGE:
			w32_project::popup_LModeFCharge(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_PARTIALCHARGE:
			w32_project::popup_LModePCharge(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_ATOMTYPE:
			w32_project::popup_LModeAtomType(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_BUILDERID:
			w32_project::popup_LModeBuilderID(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_BONDTYPE:
			w32_project::popup_LModeBondType(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_RESIDUE:
			w32_project::popup_LModeResidue(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_SECSTR:
			w32_project::popup_LModeSecStruct(hwnd);
			retval = 0;
			break;
			
			case ID_LABEL_NOTHING:
			w32_project::popup_LModeNothing(hwnd);
			retval = 0;
			break;
			
			case ID_PROJ_ORTHOGRAPHIC:
			w32_oglview_wnd::popup_ProjOrthographic(hwnd);
			retval = 0;
			break;
			
			case ID_PROJ_PERSPECTIVE:
			w32_oglview_wnd::popup_ProjPerspective(hwnd);
			retval = 0;
			break;
			
			case ID_PROJ_S_REDBLUE:
			w32_oglview_wnd::popup_ProjSterRedBlue(hwnd);
			retval = 0;
			break;
			
			case ID_PROJ_S_RELAXED:
			w32_oglview_wnd::popup_ProjSterRelaxed(hwnd);
			retval = 0;
			break;
			
			case ID_RENDER_QUICKUPDATE:
			w32_oglview_wnd::popup_RenderQuickUpdate(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_RIBBON:
			w32_project::popup_ObjRibbon(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_P_ESP:
			w32_project::popup_ObjEPlane(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_V_ESP:
			w32_project::popup_ObjEVolume(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_S_ESP:
			w32_project::popup_ObjESurface(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_S_VDW_ESP:
			w32_project::popup_ObjEVDWSurface(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_P_ED:
			w32_project::popup_ObjEDPlane(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_S_ED:
			w32_project::popup_ObjEDSurface(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_P_MO:
			w32_project::popup_ObjMOPlane(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_V_MO:
			w32_project::popup_ObjMOVolume(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_S_MO:
			w32_project::popup_ObjMOSurface(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_P_MOD:
			w32_project::popup_ObjMODPlane(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_V_MOD:
			w32_project::popup_ObjMODVolume(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_S_MOD:
			w32_project::popup_ObjMODSurface(hwnd);
			retval = 0;
			break;
			
			case ID_OBJECTS_DEL_CURR_OBJ:
			w32_project::popup_ObjectsDeleteCurrent(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_SETUP:
			w32_project::popup_CompSetup(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_ENERGY:
			w32_project::popup_CompEnergy(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_GO:
			w32_project::popup_CompGeomOpt(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_MD:
			w32_project::popup_CompMolDyn(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_RCS:
			w32_project::popup_CompRandomSearch(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_SCS:
			w32_project::popup_CompSystematicSearch(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_MCS:
			w32_project::popup_CompMonteCarloSearch(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_PLOT_E1:
			w32_project::popup_CompTorsionEnergyPlot1D(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_PLOT_E2:
			w32_project::popup_CompTorsionEnergyPlot2D(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_POP_ANA:
			w32_project::popup_CompPopAnaElectrostatic(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_TSS:
			w32_project::popup_CompTransitionStateSearch(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_SSS:
			w32_project::popup_CompStationaryStateSearch(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_FORMULA:
			w32_project::popup_CompFormula(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_SETFC:
			w32_project::popup_CompSetFormalCharge(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_MAKERS:
			w32_project::popup_CompCreateRS(hwnd);
			retval = 0;
			break;
			
			case ID_COMPUTE_CYCLERS:
			w32_project::popup_CompCycleRS(hwnd);
			retval = 0;
			break;
			
			case ID_MD_TRAJ_VIEWER:
			w32_project::popup_TrajView(hwnd);
			retval = 0;
			break;
			
			case ID_SET_CURRENT_ORBITAL:
			w32_project::popup_SetOrbital(hwnd);
			retval = 0;
			break;
			
			case ID_HYDROGENS_ADD:
			w32_project::popup_HAdd(hwnd);
			retval = 0;
			break;
			
			case ID_HYDROGENS_REMOVE:
			w32_project::popup_HRemove(hwnd);
			retval = 0;
			break;
			
			case ID_BUILD_SOLVATE_BOX:
			w32_project::popup_SolvateBox(hwnd);
			retval = 0;
			break;
			
			case ID_BUILD_SOLVATE_SPHERE:
			w32_project::popup_SolvateSphere(hwnd);
			retval = 0;
			break;
			
			case ID_BUILD_SB_AMINO:
			w32_project::popup_BuilderAmino(hwnd);
			retval = 0;
			break;
			
			case ID_BUILD_SB_NUCLEIC:
			w32_project::popup_BuilderNucleic(hwnd);
			retval = 0;
			break;
			
			case ID_BUILD_CENTER:
			w32_project::popup_Center(hwnd);
			retval = 0;
			break;
			
			case ID_BUILD_ZAP_ALL:
			w32_project::popup_ClearAll(hwnd);
			retval = 0;
			break;
			
			case ID_ENTER_COMMAND:
			w32_project::popup_EnterCommand(hwnd);
			retval = 0;
			break;
			
			// other commands:
			// ^^^^^^^^^^^^^^^
			
			case ID_ELDVIEW_DELETEVIEW:
			w32_eldview_wnd::popup_DeleteView(hwnd);
			retval = 0;
			break;
			
			case ID_GPCVIEW_DELETEVIEW:
			w32_gpcview_wnd::popup_DeleteView(hwnd);
			retval = 0;
			break;
			
			case ID_P1DVIEW_DELETEVIEW:
			w32_p1dview_wnd::popup_DeleteView(hwnd);
			retval = 0;
			break;
			
			case ID_P2DVIEW_DELETEVIEW:
			w32_p2dview_wnd::popup_DeleteView(hwnd);
			retval = 0;
			break;
			
			case ID_RCPVIEW_DELETEVIEW:
			w32_rcpview_wnd::popup_DeleteView(hwnd);
			retval = 0;
			break;
			
			// the end ; we did not recognize the command
			// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
			
			default:
		{	char dtxt[256];
			ostrstream ds(dtxt, sizeof(dtxt));
			
			ds << "child WM_COMMAND :" << endl;
			ds << "wparam = " << (unsigned int) wparam << endl;
			ds << "lparam = " << (long) lparam << ends;
			
		//	w32_app::sMessage(dtxt);
			cout << dtxt << endl;
			
			retval = 0;
			break;		}
		}
		retval = -1;
		break;		}
		
		default:
		retval = DefMDIChildProc(hwnd, message, wparam, lparam);
	}
	
	return retval;
}

void w32_wnd::RequestUpdate(bool directly)
{
	if (directly)
	{
		InvalidateRect(my_hwnd, NULL, FALSE);
		UpdateWindow(my_hwnd);
	}
	else
	{
		InvalidateRect(my_hwnd, NULL, FALSE);
	}
}

void w32_wnd::RequestResize(int, int)
{
w32_app::sMessage("w32_wnd::RequestResize()");
}

bool w32_wnd::SetCurrent(void)
{
	if (!wglMakeCurrent(my_hdc, my_hrc))
	{
		w32_app::sErrorMessage("wglMakeCurrent() failed!");
		return false;
	}
	else
	{
		return true;
	}
}

void w32_wnd::TitleChanged(void)
{
	if (GetClient() == NULL)
	{
		w32_app::sErrorMessage("ERROR at w32_wnd::TitleChanged() ; called for an unlinked window.");
		exit(EXIT_FAILURE);
	}
	else
	{
		cout << "w32_wnd::TitleChanged() not implemented." << endl << flush;
	}
}

/*################################################################################################*/

// eof
