// T2MM3DOCV.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t2mm3docv.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include "mm2mdl.h"

#include <fstream>

/*################################################################################################*/

glut_mm3_docv::glut_mm3_docv(ostream * p1, glut_class_factory & p2) :
	glut_docv(p1, p2), mm3_docv(p1, p2), docview(p1, p2), model_simple(p1, p2)
{
}

glut_mm3_docv::~glut_mm3_docv(void)
{
}

void glut_mm3_docv::KeyEvent(graphics_view * gv, char key, int, int)
{
	mm2_mdl * mm2mdl;
	ifstream ifile;
	
	switch (key)
	{
		case 'h':
		cout << "i         -> import MM2-files" << endl;
		break;
		
		case 'i':
		mm2mdl = new mm2_mdl(& cout, * console_class_factory::GetInstance(), NULL);
		cout << "import MM2: filename ??? "; cin >> buffer;
		ifile.open(buffer, ios::in); mm2mdl->ReadStream(ifile); ifile.close();
		Reduce(mm2mdl, NOT_DEFINED); delete mm2mdl;
		UpdateAllGraphicsViews();
		break;
	}
}

/*################################################################################################*/

// eof
