// QM1ENG.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "qm1eng.h"

/*################################################################################################*/

void CopyCRD(qm1_mdl * p1, qm1_eng * p2, i32u p3)
{
	if (p3 >= p1->cs_vector.size())
	{
		cout << "cs overflow at qm1 CopyCRD()." << endl;
		exit(EXIT_FAILURE);
	}
	
	i32u n1 = 0; iter_qm1al it1;
	for (it1 = p1->atom_list.begin();it1 != p1->atom_list.end();it1++)
	{
		p2->crd[n1 * 3 + 0] = (* it1).crd_vector[p3][0];
		p2->crd[n1 * 3 + 1] = (* it1).crd_vector[p3][1];
		p2->crd[n1 * 3 + 2] = (* it1).crd_vector[p3][2];
		
		n1++;
	}
}

void CopyCRD(qm1_eng * p1, qm1_mdl * p2, i32u p3)
{
	if (p3 >= p2->cs_vector.size())
	{
		cout << "cs overflow at qm1 CopyCRD()." << endl;
		exit(EXIT_FAILURE);
	}
	
	i32u n1 = 0; iter_qm1al it1;
	for (it1 = p2->atom_list.begin();it1 != p2->atom_list.end();it1++)
	{
		(* it1).crd_vector[p3][0] = p1->crd[n1 * 3 + 0];
		(* it1).crd_vector[p3][1] = p1->crd[n1 * 3 + 1];
		(* it1).crd_vector[p3][2] = p1->crd[n1 * 3 + 2];
		
		n1++;
	}
}

/*################################################################################################*/

qm1_eng::qm1_eng(qm1_mdl & p1) : engine(), mdl(p1)
{
	natm = GetModel()->atom_list.size();
	
	atnum = new i32s[natm]; iter_qm1al it1; i32s counter = 0;
	for (it1 = GetModel()->atom_list.begin();it1 != GetModel()->atom_list.end();it1++)
	{
		atnum[counter++] = (* it1).el.GetAtomicNumber();
	}
	
	crd = new f64[natm * 3];
	d1 = new f64[natm * 3];
}

qm1_eng::~qm1_eng(void)
{
	delete[] atnum;
	
	delete[] crd;
	delete[] d1;
}

void qm1_eng::Check(i32s)
{
	const f64 delta = 0.000001;	// the finite difference step...
	
	Compute(1);
	f64 tmp1 = energy;
	
	f64 tmp2; f64 old;
	for (i32s n1 = 0;n1 < natm;n1++)
	{
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			old = crd[n1 * 3 + n2];
			crd[n1 * 3 + n2] = old + delta;
			Compute(0); tmp2 = (energy - tmp1) / delta;
			crd[n1 * 3 + n2] = old;
			
			cout << n1 << ((char) ('x' + n2)) << " ";
			cout << "a = " << d1[n1 * 3 + n2] << " ";
			cout << "n = " << tmp2 << endl;
			
			if ((n1 % 5) == 4) cin >> old;		// uses console I/O but is not relevant to the users...
		}
	}
}

f64 qm1_eng::GetGradientVectorLength(void)
{
	f64 sum = 0.0;
	
	for (i32s n1 = 0;n1 < natm;n1++)
	{
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 tmp1 = d1[n1 * 3 + n2];
			sum += tmp1 * tmp1;
		}
	}
	
	return sqrt(sum);
}

// this function is very similar to mm1_GetVDWSValue()!!!!!
// f = sum[(r/a)^-3] = sum[a^3 * r^-3]		// now seems to be r^-12
// df/dr = -3 * sum[a^3 * r^-4]

fGL qm1_eng::getVDWSurface(fGL * pp, qm1_eng * ref, fGL * dd)
{
	fGL vdwsv = 0.0;
	if (dd != NULL) dd[0] = dd[1] = dd[2] = 0.0;
	
	for (i32s n1 = 0;n1 < ref->natm;n1++)
	{
		fGL tmp1[3]; fGL r2 = 0.0;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			tmp1[n2] = pp[n2] - ref->crd[n1 * 3 + n2];
			r2 += tmp1[n2] * tmp1[n2];
		}
		
		if (r2 == 0.0) return +1.0e+35;		// numeric_limits<fGL>::max()?!?!?!
		fGL r1 = sqrt(r2);
		
		element el(ref->atnum[n1]);
		fGL tmp2 = r1 / el.GetVDWRadius();
		fGL qqq = tmp2 * tmp2 * tmp2 * tmp2;
		
		fGL tmp3 = 1.0 / (qqq * qqq * qqq);
		vdwsv += tmp3;
		
		if (dd != NULL)		// sign ??? constant ???
		{
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				fGL tmp4 = tmp1[n2] / r1;
				fGL tmp5 = tmp4 * tmp3 / tmp2;
				dd[n2] += tmp5;
			}
		}
	}
	
	return vdwsv;
}

/*################################################################################################*/

// eof
