// T3MM1DOCV.H : a graphical user interface for mm1-models.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef T3MM1DOCV_H
#define T3MM1DOCV_H

class gnome_mm1_docv;

/*################################################################################################*/

#include "t3docv.h"
#include "mm1docv.h"
#include "t3dialog.h"

#include <gnome.h>

/*################################################################################################*/

#define MM1_FILTER	"*.mm1gp"

/*################################################################################################*/

class mm1_file_open_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gnome_mm1_docv * docv;
	bool insert;
	
	public:
	
	mm1_file_open_dialog(gnome_mm1_docv *);
	~mm1_file_open_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class mm1_file_save_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gnome_mm1_docv * docv;
	
	public:
	
	mm1_file_save_dialog(gnome_mm1_docv *);
	~mm1_file_save_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class mm1_file_save_graphics_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gnome_mm1_docv * docv;
	
	public:
	
	mm1_file_save_graphics_dialog(gnome_mm1_docv *);
	~mm1_file_save_graphics_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class mm1_trajfile_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static mm1_docv * docv;
	
	public:
	
	mm1_trajfile_dialog(mm1_docv *);
	~mm1_trajfile_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

/// Combines the "##GNOME" and "##mm1" aspects of "##docview", and contains many callback handlers...

class gnome_mm1_docv : public gnome_docv, public mm1_docv
{
	protected:
	
	static GnomeUIInfo file_submenu[];
	
	static GnomeUIInfo selmodes_radio[];
	static GnomeUIInfo selmodes_submenu[];
	static GnomeUIInfo select_submenu[];
	
	static GnomeUIInfo settings_submenu[];
	
	static GnomeUIInfo viewscreate_submenu[];	// render/views
	static GnomeUIInfo views_submenu[];		// render
	static GnomeUIInfo lights_submenu[];		// render
	static GnomeUIInfo rendermode_style_radio[];
	static GnomeUIInfo rendermode_label_radio[];
	static GnomeUIInfo rendermode_color_radio[];
	static GnomeUIInfo rendermode_submenu[];	// render
	static GnomeUIInfo projection_radio[];
	static GnomeUIInfo projection_submenu[];	// render
	static GnomeUIInfo render_submenu[];
	
	static GnomeUIInfo objects_submenu[];
	
	static GnomeUIInfo compute_submenu[];
	
	static GnomeUIInfo hydrogens_submenu[];		// build
	static GnomeUIInfo library_submenu[];
	static GnomeUIInfo build_submenu[];
	
	static GnomeUIInfo popupmenu_info[];
	static GnomeUIInfo popupmenu_dummy[];		// for tearoff
	
	friend class gnome_ogl_view;
	friend class gnome_view;
	
	public:
	
	static mm1_geomopt_param * goparam;
	static mm1_moldyn_param * mdparam;
	
	public:
	
	gnome_mm1_docv(ostream *, gnome_class_factory &);
	~gnome_mm1_docv(void);
	
	void MakeLibraryWidgets(GtkMenuItem *, const char *, int);

	// the mm1-dependent popup-menu callbacks are here...
	// the mm1-dependent popup-menu callbacks are here...
	// the mm1-dependent popup-menu callbacks are here...
	
	static void popup_FileOpen(GtkWidget *, gpointer);
	static void popup_FileImport(GtkWidget *, gpointer);
	static void popup_FileExport(GtkWidget *, gpointer);
	static void popup_FileExportGraphic(GtkWidget *, gpointer);
	static void popup_FileSaveAs(GtkWidget *, gpointer);
	
	static void popup_RModeWireFrame(GtkWidget *, gpointer);
	static void popup_RModeBallAndStick(GtkWidget *, gpointer);
	static void popup_RModeVanDerWaals(GtkWidget *, gpointer);
	static void popup_RModeCylinders(GtkWidget *, gpointer);
	static void popup_RModeNothing(GtkWidget *, gpointer);

	static void popup_CModeState(GtkWidget *, gpointer);
	static void popup_CModeElement(GtkWidget *, gpointer);
	
	static void popup_LModeNothing(GtkWidget *, gpointer);
	static void popup_LModeIndex(GtkWidget *, gpointer);
	static void popup_LModeCharge(GtkWidget *, gpointer);
	static void popup_LModeElement(GtkWidget *, gpointer);
	static void popup_LModeAtomType(GtkWidget *, gpointer);
	static void popup_LModeBondType(GtkWidget *, gpointer);

	static void popup_ObjRibbon(GtkWidget *, gpointer);
	static void popup_ObjEPlane(GtkWidget *, gpointer);
	static void popup_ObjEVolume(GtkWidget *, gpointer);
	static void popup_ObjESurface(GtkWidget *, gpointer);
	static void popup_ObjVDWSurface(GtkWidget *, gpointer);
	
	static void popup_CompSetup(GtkWidget *, gpointer);
	static void popup_CompEnergy(GtkWidget *, gpointer);
	static void popup_CompGeomOpt(GtkWidget *, gpointer);
	static void popup_CompMolDyn(GtkWidget *, gpointer);
	static void popup_CompRandomSearch(GtkWidget *, gpointer);
	static void popup_CompEPlot1D(GtkWidget *, gpointer);
	static void popup_CompEPlot2D(GtkWidget *, gpointer);
	static void popup_CompFormula(GtkWidget *, gpointer);
	static void popup_TrajView(GtkWidget *, gpointer);
	
	static void popup_HAdd(GtkWidget *, gpointer);
	static void popup_HRemove(GtkWidget *, gpointer);
	static void popup_Clear(GtkWidget *, gpointer);
	static void popup_Library(GtkWidget *, gpointer);
	static void popup_Builder(GtkWidget *, gpointer);
	static void popup_Center(GtkWidget *, gpointer);
	static void popup_ConvertQM(GtkWidget *, gpointer);
	
	void GeomOptGetParam(mm1_geomopt_param &);	// virtual
	void MolDynGetParam(mm1_moldyn_param &);	// virtual
};

/*################################################################################################*/

#endif	// T3MM1DOCV_H

// eof
