// T2VIEWS.H : a view window class for GLUT.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is for TARGET2...

#ifndef T2VIEWS_H
#define T2VIEWS_H

class glut_ogl_view;
class glut_graphics_view;

class glut_class_factory;

/*################################################################################################*/

#include "views.h"
#include "t2docv.h"

#include <vector>
using namespace std;

/*################################################################################################*/

class glut_view : virtual public view
{
	protected:
	
	glut_docv * docv;
	
	i32s glut_id;
	
	public:
	
	glut_view(glut_docv *);
	virtual ~glut_view(void);
	
	docview * GetDV(void);		// virtual
};

/*################################################################################################*/

class glut_ogl_view : public glut_view, virtual public ogl_view
{
	private:
	
	static vector<glut_ogl_view *> ogl_vector;
	
	public:
	
	glut_ogl_view(glut_docv *);
	virtual ~glut_ogl_view(void);
	
	void Update(bool);			// virtual
	void SetTitle(const char *);		// virtual
	
	void SetCurrent(void);			// virtual
	
	private:
	
	virtual void DisplayEvent(void) = 0;
	virtual void KeyboardEvent(unsigned char, int, int) = 0;
	virtual void SpecialEvent(int, int, int) = 0;
	
	private:
	
	static glut_ogl_view * GetWindow(int);
	
	static void DisplayHandler(void);
	static void KeyboardHandler(unsigned char, int, int);
	static void SpecialHandler(int, int, int);
	
	static void ReshapeHandler(int, int);
	
	static void MouseHandler(int, int, int, int);
	static void MotionHandler(int, int);
};

/*################################################################################################*/

class glut_graphics_view : public glut_ogl_view, public graphics_view
{
	private:
	
	glut_graphics_view(glut_docv *, camera *);
	
	friend class glut_class_factory;
	
	public:
	
	~glut_graphics_view(void);
	
	private:
	
	void DisplayEvent(void);				// virtual
	void KeyboardEvent(unsigned char, int, int);		// virtual
	void SpecialEvent(int, int, int);			// virtual
};

/*################################################################################################*/

class glut_plot1d_view : public glut_ogl_view, public plot1d_view
{
	private:
	
	glut_plot1d_view(model_simple *, i32s, i32s);
	
	friend class glut_class_factory;
	
	public:
	
	~glut_plot1d_view(void);
	
	private:
	
	void DisplayEvent(void);				// virtual
	void KeyboardEvent(unsigned char, int, int);		// virtual
	void SpecialEvent(int, int, int);			// virtual
};

class glut_plot2d_view : public glut_ogl_view, public plot2d_view
{
	private:
	
	glut_plot2d_view(model_simple *, i32s, i32s);
	
	friend class glut_class_factory;
	
	public:
	
	~glut_plot2d_view(void);
	
	private:
	
	void DisplayEvent(void);				// virtual
	void KeyboardEvent(unsigned char, int, int);		// virtual
	void SpecialEvent(int, int, int);			// virtual
};

/*################################################################################################*/

class glut_enlevdiag_view : public glut_ogl_view, public enlevdiag_view
{
	private:
	
	glut_enlevdiag_view(qm1_mdl *);
	
	friend class glut_class_factory;
	
	public:
	
	~glut_enlevdiag_view(void);
	
	private:
	
	void DisplayEvent(void);				// virtual
	void KeyboardEvent(unsigned char, int, int);		// virtual
	void SpecialEvent(int, int, int);			// virtual
};

/*################################################################################################*/

/// This class has a private constructor, so you can't use this in the usual way; use the GetInstance() instead.

class glut_class_factory : public graphics_class_factory
{
	private:
	
	static glut_class_factory * instance;
	glut_class_factory(void);
	
	public:
	
	~glut_class_factory(void);
	static glut_class_factory * GetInstance(void);
	
	err_util * ProduceErrUtil(void);	// virtual
	prefs * ProducePrefs(void);		// virtual
	
	graphics_view * ProduceGraphicsView(docview *, camera *, bool);		// virtual
	
	plot1d_view * ProducePlot1DView(docview *, i32s, i32s);		// virtual
	plot2d_view * ProducePlot2DView(docview *, i32s, i32s);		// virtual
	
	enlevdiag_view * ProduceEnLevDiagView(qm1_mdl *);		// virtual
};

/*################################################################################################*/

#endif	// T2VIEWS_H

// eof
