// QM1E_MPQC.H : the MPQC engine.

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef QM1E_MPQC_H
#define QM1E_MPQC_H

#ifdef ENABLE_MPQC

class qm1_eng_mpqc;

/*################################################################################################*/

#include "qm1eng.h"
#include "qm1mdl.h"

#include <fstream>
using namespace std;

#include "util/keyval/keyval.h"			// KeyVal

#include "util/group/message.h"			// MessageGrp
#include "util/group/thread.h"			// ThreadGrp

#include "chemistry/molecule/energy.h"		// MolecularEnergy
#include "chemistry/qc/wfn/obwfn.h"		// OneBodyWavefunction
#include "chemistry/qc/wfn/wfn.h"		// Wavefunction

#include "math/scmat/abstract.h"		// SCMatrix

/*################################################################################################*/

/**	The MPQC "wrapper" engine class...

	Strategy: 
	Initialize using a standard MPQC input file -> we will have also an input file 
	generator. For each different situation (closed shell, open shell, whatever) we 
	will have a different class. This is only for closed shell cases -> split this 
	to a base class/derived classes in future!!!!! For example, open shell cases 
	might have separate matrices for alpha and beta orbitals etc... 
*/

class qm1_eng_mpqc : public qm1_eng
{
	protected:
	
	static i32u ifile_name_counter;
	
	RefMessageGrp grp;
	RefThreadGrp thread;
	
	RefParsedKeyVal parsedkv;
	RefKeyVal keyval;
	
	RefMolecularEnergy mole;
	
	RefOneBodyWavefunction obwfn;		// for plotting...
	RefWavefunction wfn;			// for plotting...
	
	public:
	
	qm1_eng_mpqc(qm1_mdl &, i32s);
	~qm1_eng_mpqc(void);
	
	void GetInputFileName(char *, i32u);
	void WriteInputFile(ofstream &, i32s);
	
	i32s GetOrbitalCount(void);	// virtual
	f64 GetOrbitalEnergy(i32s);	// virtual
	
	i32s GetElectronCount(void);	// virtual
	
	/**	It seems that we get the energy in atomic units... A set of unit conversion 
		functions should be made that makes conversions si-units <-> atomic units <-> 
		whatever units. These engine classes should have some "states" which determine 
		units that are printed out ?!?!?!?!?!?
	*/
	
	void Compute(i32s);		// virtual
	
	void SetupPlotting(void);	// virtual
	
	fGL GetESP(fGL *, fGL *);	// virtual
	fGL GetElDens(fGL *, fGL *);	// virtual
	
	fGL GetOrbital(fGL *, fGL *);	// virtual
	fGL GetOrbDens(fGL *, fGL *);	// virtual
};

/*################################################################################################*/

#endif	// ENABLE_MPQC
#endif	// QM1E_MPQC_H

// eof
