with Iirs; use Iirs;

package Parse is
   -- Parse a single design unit.
   -- The scanner must have been initialized, however, the current_token
   -- shouldn't have been set.
   -- At return, the last token accepted is the semi_colon that terminates
   -- the library unit.
   -- Return Null_Iir when end of file.
   function Parse_Design_Unit return Iir_Design_Unit;

   --  Parse a file.
   --  The scanner must habe been initialized as for parse_design_unit.
   --  Return Null_Iir in case of error.
   function Parse_Design_File return Iir_Design_File;
end Parse;
