with Ada.Unchecked_Conversion;
with Grt.Options; use Grt.Options;
with Grt.Main;

pragma Warnings (Off);
with Grt.Rtis_Binding;
pragma Warnings (On);


function Ghdl_Main (Argc : Integer; Argv : System.Address)
                   return Integer
is
   --  Grt_Init corresponds to the 'adainit' subprogram for grt.
   procedure Grt_Init;
   pragma Import (C, Grt_Init, "grt_init");

   function To_Argv_Type is new Ada.Unchecked_Conversion
     (Source => System.Address, Target => Grt.Options.Argv_Type);
begin
   Grt.Options.Progname := To_Argv_Type (Argv)(0);
   Grt.Options.Argc := Argc;
   Grt.Options.Argv := To_Argv_Type (Argv);

   Grt_Init;
   Grt.Main.Run;
   return 0;
end Ghdl_Main;
